package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails = {
    import AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails(
          `type`.map(value => value)
        )
    def `type`: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.ReadOnly =
    new Wrapper(impl)
}
