package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataDetails(
    blockDeviceMappingSet: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
    ]] = Optional.Absent,
    capacityReservationSpecification: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
    ] = Optional.Absent,
    cpuOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
    ] = Optional.Absent,
    creditSpecification: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
    ] = Optional.Absent,
    disableApiStop: Optional[Boolean] = Optional.Absent,
    disableApiTermination: Optional[Boolean] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    elasticGpuSpecificationSet: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
    ]] = Optional.Absent,
    elasticInferenceAcceleratorSet: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
    ]] = Optional.Absent,
    enclaveOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataEnclaveOptionsDetails
    ] = Optional.Absent,
    hibernationOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
    ] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataIamInstanceProfileDetails
    ] = Optional.Absent,
    imageId: Optional[NonEmptyString] = Optional.Absent,
    instanceInitiatedShutdownBehavior: Optional[NonEmptyString] =
      Optional.Absent,
    instanceMarketOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
    ] = Optional.Absent,
    instanceRequirements: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
    ] = Optional.Absent,
    instanceType: Optional[NonEmptyString] = Optional.Absent,
    kernelId: Optional[NonEmptyString] = Optional.Absent,
    keyName: Optional[NonEmptyString] = Optional.Absent,
    licenseSet: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
    ]] = Optional.Absent,
    maintenanceOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
    ] = Optional.Absent,
    metadataOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
    ] = Optional.Absent,
    monitoring: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
    ] = Optional.Absent,
    networkInterfaceSet: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
    ]] = Optional.Absent,
    placement: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
    ] = Optional.Absent,
    privateDnsNameOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
    ] = Optional.Absent,
    ramDiskId: Optional[NonEmptyString] = Optional.Absent,
    securityGroupIdSet: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    securityGroupSet: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    userData: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataDetails = {
    import AwsEc2LaunchTemplateDataDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataDetails
      .builder()
      .optionallyWith(
        blockDeviceMappingSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappingSet)
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(disableApiStop.map(value => value: java.lang.Boolean))(
        _.disableApiStop
      )
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        elasticGpuSpecificationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecificationSet)
      .optionallyWith(
        elasticInferenceAcceleratorSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAcceleratorSet)
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        kernelId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        licenseSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSet)
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaceSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaceSet)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(
        ramDiskId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ramDiskId)
      .optionallyWith(
        securityGroupIdSet.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIdSet)
      .optionallyWith(
        securityGroupSet.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupSet)
      .optionallyWith(
        userData.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userData)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails =
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails(
        blockDeviceMappingSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capacityReservationSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        disableApiStop.map(value => value),
        disableApiTermination.map(value => value),
        ebsOptimized.map(value => value),
        elasticGpuSpecificationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAcceleratorSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enclaveOptions.map(value => value.asEditable),
        hibernationOptions.map(value => value.asEditable),
        iamInstanceProfile.map(value => value.asEditable),
        imageId.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        instanceMarketOptions.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        licenseSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maintenanceOptions.map(value => value.asEditable),
        metadataOptions.map(value => value.asEditable),
        monitoring.map(value => value.asEditable),
        networkInterfaceSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable),
        ramDiskId.map(value => value),
        securityGroupIdSet.map(value => value),
        securityGroupSet.map(value => value),
        userData.map(value => value)
      )
    def blockDeviceMappingSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.ReadOnly
    ]]
    def capacityReservationSpecification: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.ReadOnly
    ]
    def cpuOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails.ReadOnly
    ]
    def creditSpecification: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails.ReadOnly
    ]
    def disableApiStop: Optional[Boolean]
    def disableApiTermination: Optional[Boolean]
    def ebsOptimized: Optional[Boolean]
    def elasticGpuSpecificationSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.ReadOnly
    ]]
    def elasticInferenceAcceleratorSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.ReadOnly
    ]]
    def enclaveOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataEnclaveOptionsDetails.ReadOnly
    ]
    def hibernationOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails.ReadOnly
    ]
    def iamInstanceProfile: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataIamInstanceProfileDetails.ReadOnly
    ]
    def imageId: Optional[NonEmptyString]
    def instanceInitiatedShutdownBehavior: Optional[NonEmptyString]
    def instanceMarketOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.ReadOnly
    ]
    def instanceRequirements: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails.ReadOnly
    ]
    def instanceType: Optional[NonEmptyString]
    def kernelId: Optional[NonEmptyString]
    def keyName: Optional[NonEmptyString]
    def licenseSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.ReadOnly
    ]]
    def maintenanceOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.ReadOnly
    ]
    def metadataOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails.ReadOnly
    ]
    def monitoring: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails.ReadOnly
    ]
    def networkInterfaceSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.ReadOnly
    ]]
    def placement: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails.ReadOnly
    ]
    def privateDnsNameOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.ReadOnly
    ]
    def ramDiskId: Optional[NonEmptyString]
    def securityGroupIdSet: Optional[List[NonEmptyString]]
    def securityGroupSet: Optional[List[NonEmptyString]]
    def userData: Optional[NonEmptyString]
    def getBlockDeviceMappingSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("blockDeviceMappingSet", blockDeviceMappingSet)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getCpuOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCreditSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getDisableApiStop: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiStop", disableApiStop)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getElasticGpuSpecificationSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecificationSet",
      elasticGpuSpecificationSet
    )
    def getElasticInferenceAcceleratorSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorSet",
      elasticInferenceAcceleratorSet
    )
    def getEnclaveOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataEnclaveOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataIamInstanceProfileDetails.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "instanceInitiatedShutdownBehavior",
      instanceInitiatedShutdownBehavior
    )
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getInstanceRequirements: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLicenseSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("licenseSet", licenseSet)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaceSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaceSet", networkInterfaceSet)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getRamDiskId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ramDiskId", ramDiskId)
    def getSecurityGroupIdSet: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIdSet", securityGroupIdSet)
    def getSecurityGroupSet: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupSet", securityGroupSet)
    def getUserData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.ReadOnly {
    override val blockDeviceMappingSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappingSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
            .wrap(item)
        }.toList
      )
    override val capacityReservationSpecification: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
          .wrap(value)
      )
    override val cpuOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
          .wrap(value)
      )
    override val creditSpecification: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.creditSpecification())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
          .wrap(value)
      )
    override val disableApiStop: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disableApiStop())
      .map(value => value: Boolean)
    override val disableApiTermination: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiTermination())
        .map(value => value: Boolean)
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val elasticGpuSpecificationSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticGpuSpecificationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
            .wrap(item)
        }.toList
      )
    override val elasticInferenceAcceleratorSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAcceleratorSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
            .wrap(item)
        }.toList
      )
    override val enclaveOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataEnclaveOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enclaveOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataEnclaveOptionsDetails
          .wrap(value)
      )
    override val hibernationOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hibernationOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
          .wrap(value)
      )
    override val iamInstanceProfile: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataIamInstanceProfileDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataIamInstanceProfileDetails
          .wrap(value)
      )
    override val imageId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceInitiatedShutdownBehavior: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val instanceMarketOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMarketOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
          .wrap(value)
      )
    override val instanceRequirements: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRequirements())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
          .wrap(value)
      )
    override val instanceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kernelId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
            .wrap(item)
        }.toList
      )
    override val maintenanceOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
          .wrap(value)
      )
    override val metadataOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
          .wrap(value)
      )
    override val monitoring: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoring())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
          .wrap(value)
      )
    override val networkInterfaceSet: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
            .wrap(item)
        }.toList
      )
    override val placement: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.placement())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPlacementDetails
          .wrap(value)
      )
    override val privateDnsNameOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsNameOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
          .wrap(value)
      )
    override val ramDiskId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ramDiskId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroupIdSet: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIdSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val securityGroupSet: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val userData: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.ReadOnly =
    new Wrapper(impl)
}
