package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataCreditSpecificationDetails(
    cpuCredits: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails = {
    import AwsEc2LaunchTemplateDataCreditSpecificationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
      .builder()
      .optionallyWith(
        cpuCredits.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cpuCredits)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataCreditSpecificationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataCreditSpecificationDetails(
          cpuCredits.map(value => value)
        )
    def cpuCredits: Optional[NonEmptyString]
    def getCpuCredits: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cpuCredits", cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails.ReadOnly {
    override val cpuCredits: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuCredits())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCreditSpecificationDetails.ReadOnly =
    new Wrapper(impl)
}
