package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2InstanceNetworkInterfacesDetails(
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails = {
    import AwsEc2InstanceNetworkInterfacesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails
      .wrap(buildAwsValue())
}
object AwsEc2InstanceNetworkInterfacesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails =
      zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails(
        networkInterfaceId.map(value => value)
      )
    def networkInterfaceId: Optional[NonEmptyString]
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails
  ) extends zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.ReadOnly {
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails
  ): zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.ReadOnly =
    new Wrapper(impl)
}
