package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDmsReplicationInstanceReplicationSubnetGroupDetails(
    replicationSubnetGroupIdentifier: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails = {
    import AwsDmsReplicationInstanceReplicationSubnetGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
      .builder()
      .optionallyWith(
        replicationSubnetGroupIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicationSubnetGroupIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
      .wrap(buildAwsValue())
}
object AwsDmsReplicationInstanceReplicationSubnetGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails =
      zio.aws.securityhub.model
        .AwsDmsReplicationInstanceReplicationSubnetGroupDetails(
          replicationSubnetGroupIdentifier.map(value => value)
        )
    def replicationSubnetGroupIdentifier: Optional[NonEmptyString]
    def getReplicationSubnetGroupIdentifier
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "replicationSubnetGroupIdentifier",
      replicationSubnetGroupIdentifier
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
  ) extends zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.ReadOnly {
    override val replicationSubnetGroupIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSubnetGroupIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
  ): zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.ReadOnly =
    new Wrapper(impl)
}
