package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupPlanAdvancedBackupSettingsDetails(
    backupOptions: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    resourceType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails = {
    import AwsBackupBackupPlanAdvancedBackupSettingsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
      .builder()
      .optionallyWith(
        backupOptions.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.backupOptions)
      .optionallyWith(
        resourceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
      .wrap(buildAwsValue())
}
object AwsBackupBackupPlanAdvancedBackupSettingsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails =
      zio.aws.securityhub.model
        .AwsBackupBackupPlanAdvancedBackupSettingsDetails(
          backupOptions.map(value => value),
          resourceType.map(value => value)
        )
    def backupOptions: Optional[Map[NonEmptyString, NonEmptyString]]
    def resourceType: Optional[NonEmptyString]
    def getBackupOptions
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("backupOptions", backupOptions)
    def getResourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.ReadOnly {
    override val backupOptions: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val resourceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
  ): zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.ReadOnly =
    new Wrapper(impl)
}
