package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAthenaWorkGroupDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[NonEmptyString] = Optional.Absent,
    configuration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupDetails = {
    import AwsAthenaWorkGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsAthenaWorkGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAthenaWorkGroupDetails.wrap(buildAwsValue())
}
object AwsAthenaWorkGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsAthenaWorkGroupDetails =
      zio.aws.securityhub.model.AwsAthenaWorkGroupDetails(
        name.map(value => value),
        description.map(value => value),
        state.map(value => value),
        configuration.map(value => value.asEditable)
      )
    def name: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def state: Optional[NonEmptyString]
    def configuration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupDetails
  ) extends zio.aws.securityhub.model.AwsAthenaWorkGroupDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val configuration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupDetails
  ): zio.aws.securityhub.model.AwsAthenaWorkGroupDetails.ReadOnly = new Wrapper(
    impl
  )
}
