package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAthenaWorkGroupConfigurationDetails(
    resultConfiguration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationDetails = {
    import AwsAthenaWorkGroupConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
      .builder()
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsAthenaWorkGroupConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails =
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails(
        resultConfiguration.map(value => value.asEditable)
      )
    def resultConfiguration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails.ReadOnly
    ]
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails.ReadOnly {
    override val resultConfiguration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resultConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationDetails
  ): zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
