package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAppSyncGraphQlApiOpenIdConnectConfigDetails(
    authTtL: Optional[Long] = Optional.Absent,
    clientId: Optional[NonEmptyString] = Optional.Absent,
    iatTtL: Optional[Long] = Optional.Absent,
    issuer: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails = {
    import AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
      .builder()
      .optionallyWith(authTtL.map(value => value: java.lang.Long))(_.authTtL)
      .optionallyWith(
        clientId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(iatTtL.map(value => value: java.lang.Long))(_.iatTtL)
      .optionallyWith(
        issuer.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuer)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
      .wrap(buildAwsValue())
}
object AwsAppSyncGraphQlApiOpenIdConnectConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails =
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails(
        authTtL.map(value => value),
        clientId.map(value => value),
        iatTtL.map(value => value),
        issuer.map(value => value)
      )
    def authTtL: Optional[Long]
    def clientId: Optional[NonEmptyString]
    def iatTtL: Optional[Long]
    def issuer: Optional[NonEmptyString]
    def getAuthTtL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("authTtL", authTtL)
    def getClientId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getIatTtL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("iatTtL", iatTtL)
    def getIssuer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuer", issuer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
  ) extends zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly {
    override val authTtL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.authTtL())
      .map(value => value: Long)
    override val clientId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iatTtL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.iatTtL())
      .map(value => value: Long)
    override val issuer: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
  ): zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly =
    new Wrapper(impl)
}
