package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociationStateDetails(
    state: Optional[NonEmptyString] = Optional.Absent,
    statusMessage: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AssociationStateDetails = {
    import AssociationStateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AssociationStateDetails
      .builder()
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        statusMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AssociationStateDetails.ReadOnly =
    zio.aws.securityhub.model.AssociationStateDetails.wrap(buildAwsValue())
}
object AssociationStateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AssociationStateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AssociationStateDetails =
      zio.aws.securityhub.model.AssociationStateDetails(
        state.map(value => value),
        statusMessage.map(value => value)
      )
    def state: Optional[NonEmptyString]
    def statusMessage: Optional[NonEmptyString]
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AssociationStateDetails
  ) extends zio.aws.securityhub.model.AssociationStateDetails.ReadOnly {
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statusMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AssociationStateDetails
  ): zio.aws.securityhub.model.AssociationStateDetails.ReadOnly = new Wrapper(
    impl
  )
}
