package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcInfoIpv6CidrBlockSetDetails(
    ipv6CidrBlock: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails = {
    import VpcInfoIpv6CidrBlockSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails
      .builder()
      .optionallyWith(
        ipv6CidrBlock.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ipv6CidrBlock)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.ReadOnly =
    zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails
      .wrap(buildAwsValue())
}
object VpcInfoIpv6CidrBlockSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails =
      zio.aws.securityhub.model
        .VpcInfoIpv6CidrBlockSetDetails(ipv6CidrBlock.map(value => value))
    def ipv6CidrBlock: Optional[NonEmptyString]
    def getIpv6CidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails
  ) extends zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.ReadOnly {
    override val ipv6CidrBlock: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails
  ): zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.ReadOnly =
    new Wrapper(impl)
}
