package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityHubConfigurationRequest(
    autoEnableControls: Optional[Boolean] = Optional.Absent,
    controlFindingGenerator: Optional[
      zio.aws.securityhub.model.ControlFindingGenerator
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest = {
    import UpdateSecurityHubConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest
      .builder()
      .optionallyWith(
        autoEnableControls.map(value => value: java.lang.Boolean)
      )(_.autoEnableControls)
      .optionallyWith(controlFindingGenerator.map(value => value.unwrap))(
        _.controlFindingGenerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UpdateSecurityHubConfigurationRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateSecurityHubConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateSecurityHubConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.UpdateSecurityHubConfigurationRequest =
      zio.aws.securityhub.model.UpdateSecurityHubConfigurationRequest(
        autoEnableControls.map(value => value),
        controlFindingGenerator.map(value => value)
      )
    def autoEnableControls: Optional[Boolean]
    def controlFindingGenerator
        : Optional[zio.aws.securityhub.model.ControlFindingGenerator]
    def getAutoEnableControls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnableControls", autoEnableControls)
    def getControlFindingGenerator: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ControlFindingGenerator
    ] = AwsError.unwrapOptionField(
      "controlFindingGenerator",
      controlFindingGenerator
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest
  ) extends zio.aws.securityhub.model.UpdateSecurityHubConfigurationRequest.ReadOnly {
    override val autoEnableControls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnableControls())
      .map(value => value: Boolean)
    override val controlFindingGenerator
        : Optional[zio.aws.securityhub.model.ControlFindingGenerator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlFindingGenerator())
        .map(value =>
          zio.aws.securityhub.model.ControlFindingGenerator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest
  ): zio.aws.securityhub.model.UpdateSecurityHubConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
