package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateOrganizationConfigurationRequest(
    autoEnable: Boolean,
    autoEnableStandards: Optional[
      zio.aws.securityhub.model.AutoEnableStandards
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest = {
    import UpdateOrganizationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest
      .builder()
      .autoEnable(autoEnable: java.lang.Boolean)
      .optionallyWith(autoEnableStandards.map(value => value.unwrap))(
        _.autoEnableStandards
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UpdateOrganizationConfigurationRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateOrganizationConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateOrganizationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.UpdateOrganizationConfigurationRequest =
      zio.aws.securityhub.model.UpdateOrganizationConfigurationRequest(
        autoEnable,
        autoEnableStandards.map(value => value)
      )
    def autoEnable: Boolean
    def autoEnableStandards
        : Optional[zio.aws.securityhub.model.AutoEnableStandards]
    def getAutoEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(autoEnable)
    def getAutoEnableStandards
        : ZIO[Any, AwsError, zio.aws.securityhub.model.AutoEnableStandards] =
      AwsError.unwrapOptionField("autoEnableStandards", autoEnableStandards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest
  ) extends zio.aws.securityhub.model.UpdateOrganizationConfigurationRequest.ReadOnly {
    override val autoEnable: Boolean = impl.autoEnable(): Boolean
    override val autoEnableStandards
        : Optional[zio.aws.securityhub.model.AutoEnableStandards] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoEnableStandards())
        .map(value => zio.aws.securityhub.model.AutoEnableStandards.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest
  ): zio.aws.securityhub.model.UpdateOrganizationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
