package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait UnprocessedErrorCode {
  def unwrap
      : software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode
}
object UnprocessedErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode
  ): zio.aws.securityhub.model.UnprocessedErrorCode = value match {
    case software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.INVALID_INPUT =>
      val r = INVALID_INPUT
      r
    case software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.NOT_FOUND =>
      val r = NOT_FOUND
      r
    case software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.LIMIT_EXCEEDED =>
      val r = LIMIT_EXCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.UnprocessedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode =
      software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INVALID_INPUT
      extends zio.aws.securityhub.model.UnprocessedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode =
      software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.INVALID_INPUT
  }
  case object ACCESS_DENIED
      extends zio.aws.securityhub.model.UnprocessedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode =
      software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.ACCESS_DENIED
  }
  case object NOT_FOUND extends zio.aws.securityhub.model.UnprocessedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode =
      software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.NOT_FOUND
  }
  case object LIMIT_EXCEEDED
      extends zio.aws.securityhub.model.UnprocessedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode =
      software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode.LIMIT_EXCEEDED
  }
}
