package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnprocessedAutomationRule(
    ruleArn: Optional[NonEmptyString] = Optional.Absent,
    errorCode: Optional[Integer] = Optional.Absent,
    errorMessage: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule = {
    import UnprocessedAutomationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule
      .builder()
      .optionallyWith(
        ruleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(errorCode.map(value => value: java.lang.Integer))(
        _.errorCode
      )
      .optionallyWith(
        errorMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly =
    zio.aws.securityhub.model.UnprocessedAutomationRule.wrap(buildAwsValue())
}
object UnprocessedAutomationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UnprocessedAutomationRule =
      zio.aws.securityhub.model.UnprocessedAutomationRule(
        ruleArn.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def ruleArn: Optional[NonEmptyString]
    def errorCode: Optional[Integer]
    def errorMessage: Optional[NonEmptyString]
    def getRuleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getErrorCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule
  ) extends zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly {
    override val ruleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val errorCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: Integer)
    override val errorMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule
  ): zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly = new Wrapper(
    impl
  )
}
