package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StandardsControlAssociationId(
    securityControlId: NonEmptyString,
    standardsArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId = {
    import StandardsControlAssociationId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId
      .builder()
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .standardsArn(NonEmptyString.unwrap(standardsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly =
    zio.aws.securityhub.model.StandardsControlAssociationId
      .wrap(buildAwsValue())
}
object StandardsControlAssociationId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsControlAssociationId =
      zio.aws.securityhub.model
        .StandardsControlAssociationId(securityControlId, standardsArn)
    def securityControlId: NonEmptyString
    def standardsArn: NonEmptyString
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getStandardsArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId
  ) extends zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly {
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val standardsArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.standardsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId
  ): zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly =
    new Wrapper(impl)
}
