package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{Timestamp, NonEmptyString}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StandardsControl(
    standardsControlArn: Optional[NonEmptyString] = Optional.Absent,
    controlStatus: Optional[zio.aws.securityhub.model.ControlStatus] =
      Optional.Absent,
    disabledReason: Optional[NonEmptyString] = Optional.Absent,
    controlStatusUpdatedAt: Optional[Timestamp] = Optional.Absent,
    controlId: Optional[NonEmptyString] = Optional.Absent,
    title: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    remediationUrl: Optional[NonEmptyString] = Optional.Absent,
    severityRating: Optional[zio.aws.securityhub.model.SeverityRating] =
      Optional.Absent,
    relatedRequirements: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsControl = {
    import StandardsControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsControl
      .builder()
      .optionallyWith(
        standardsControlArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsControlArn)
      .optionallyWith(controlStatus.map(value => value.unwrap))(_.controlStatus)
      .optionallyWith(
        disabledReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.disabledReason)
      .optionallyWith(
        controlStatusUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.controlStatusUpdatedAt)
      .optionallyWith(
        controlId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.controlId)
      .optionallyWith(
        title.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        remediationUrl.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.remediationUrl)
      .optionallyWith(severityRating.map(value => value.unwrap))(
        _.severityRating
      )
      .optionallyWith(
        relatedRequirements.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedRequirements)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StandardsControl.ReadOnly =
    zio.aws.securityhub.model.StandardsControl.wrap(buildAwsValue())
}
object StandardsControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsControl =
      zio.aws.securityhub.model.StandardsControl(
        standardsControlArn.map(value => value),
        controlStatus.map(value => value),
        disabledReason.map(value => value),
        controlStatusUpdatedAt.map(value => value),
        controlId.map(value => value),
        title.map(value => value),
        description.map(value => value),
        remediationUrl.map(value => value),
        severityRating.map(value => value),
        relatedRequirements.map(value => value)
      )
    def standardsControlArn: Optional[NonEmptyString]
    def controlStatus: Optional[zio.aws.securityhub.model.ControlStatus]
    def disabledReason: Optional[NonEmptyString]
    def controlStatusUpdatedAt: Optional[Timestamp]
    def controlId: Optional[NonEmptyString]
    def title: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def remediationUrl: Optional[NonEmptyString]
    def severityRating: Optional[zio.aws.securityhub.model.SeverityRating]
    def relatedRequirements: Optional[List[NonEmptyString]]
    def getStandardsControlArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsControlArn", standardsControlArn)
    def getControlStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.ControlStatus] =
      AwsError.unwrapOptionField("controlStatus", controlStatus)
    def getDisabledReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
    def getControlStatusUpdatedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("controlStatusUpdatedAt", controlStatusUpdatedAt)
    def getControlId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("controlId", controlId)
    def getTitle: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRemediationUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("remediationUrl", remediationUrl)
    def getSeverityRating
        : ZIO[Any, AwsError, zio.aws.securityhub.model.SeverityRating] =
      AwsError.unwrapOptionField("severityRating", severityRating)
    def getRelatedRequirements: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("relatedRequirements", relatedRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControl
  ) extends zio.aws.securityhub.model.StandardsControl.ReadOnly {
    override val standardsControlArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardsControlArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val controlStatus
        : Optional[zio.aws.securityhub.model.ControlStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlStatus())
        .map(value => zio.aws.securityhub.model.ControlStatus.wrap(value))
    override val disabledReason: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disabledReason())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val controlStatusUpdatedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlStatusUpdatedAt())
        .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val controlId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.controlId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val title: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val remediationUrl: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediationUrl())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val severityRating
        : Optional[zio.aws.securityhub.model.SeverityRating] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityRating())
        .map(value => zio.aws.securityhub.model.SeverityRating.wrap(value))
    override val relatedRequirements: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControl
  ): zio.aws.securityhub.model.StandardsControl.ReadOnly = new Wrapper(impl)
}
