package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.securityhub.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.SortOrder
  ): zio.aws.securityhub.model.SortOrder = value match {
    case software.amazon.awssdk.services.securityhub.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.SortOrder.ASC =>
      val r = asc
      r
    case software.amazon.awssdk.services.securityhub.model.SortOrder.DESC =>
      val r = desc
      r
  }
  case object unknownToSdkVersion extends zio.aws.securityhub.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SortOrder =
      software.amazon.awssdk.services.securityhub.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object asc extends zio.aws.securityhub.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SortOrder =
      software.amazon.awssdk.services.securityhub.model.SortOrder.ASC
  }
  case object desc extends zio.aws.securityhub.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SortOrder =
      software.amazon.awssdk.services.securityhub.model.SortOrder.DESC
  }
}
