package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SecurityControl(
    securityControlId: NonEmptyString,
    securityControlArn: NonEmptyString,
    title: NonEmptyString,
    description: NonEmptyString,
    remediationUrl: NonEmptyString,
    severityRating: zio.aws.securityhub.model.SeverityRating,
    securityControlStatus: zio.aws.securityhub.model.ControlStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SecurityControl = {
    import SecurityControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SecurityControl
      .builder()
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .securityControlArn(
        NonEmptyString.unwrap(securityControlArn): java.lang.String
      )
      .title(NonEmptyString.unwrap(title): java.lang.String)
      .description(NonEmptyString.unwrap(description): java.lang.String)
      .remediationUrl(NonEmptyString.unwrap(remediationUrl): java.lang.String)
      .severityRating(severityRating.unwrap)
      .securityControlStatus(securityControlStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SecurityControl.ReadOnly =
    zio.aws.securityhub.model.SecurityControl.wrap(buildAwsValue())
}
object SecurityControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SecurityControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SecurityControl =
      zio.aws.securityhub.model.SecurityControl(
        securityControlId,
        securityControlArn,
        title,
        description,
        remediationUrl,
        severityRating,
        securityControlStatus
      )
    def securityControlId: NonEmptyString
    def securityControlArn: NonEmptyString
    def title: NonEmptyString
    def description: NonEmptyString
    def remediationUrl: NonEmptyString
    def severityRating: zio.aws.securityhub.model.SeverityRating
    def securityControlStatus: zio.aws.securityhub.model.ControlStatus
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getSecurityControlArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlArn)
    def getTitle: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(title)
    def getDescription: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(description)
    def getRemediationUrl: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(remediationUrl)
    def getSeverityRating
        : ZIO[Any, Nothing, zio.aws.securityhub.model.SeverityRating] =
      ZIO.succeed(severityRating)
    def getSecurityControlStatus
        : ZIO[Any, Nothing, zio.aws.securityhub.model.ControlStatus] =
      ZIO.succeed(securityControlStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SecurityControl
  ) extends zio.aws.securityhub.model.SecurityControl.ReadOnly {
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val securityControlArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlArn())
    override val title: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.title())
    override val description: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.description())
    override val remediationUrl: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.remediationUrl())
    override val severityRating: zio.aws.securityhub.model.SeverityRating =
      zio.aws.securityhub.model.SeverityRating.wrap(impl.severityRating())
    override val securityControlStatus
        : zio.aws.securityhub.model.ControlStatus =
      zio.aws.securityhub.model.ControlStatus.wrap(impl.securityControlStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SecurityControl
  ): zio.aws.securityhub.model.SecurityControl.ReadOnly = new Wrapper(impl)
}
