package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteSetDetails(
    carrierGatewayId: Optional[NonEmptyString] = Optional.Absent,
    coreNetworkArn: Optional[NonEmptyString] = Optional.Absent,
    destinationCidrBlock: Optional[NonEmptyString] = Optional.Absent,
    destinationIpv6CidrBlock: Optional[NonEmptyString] = Optional.Absent,
    destinationPrefixListId: Optional[NonEmptyString] = Optional.Absent,
    egressOnlyInternetGatewayId: Optional[NonEmptyString] = Optional.Absent,
    gatewayId: Optional[NonEmptyString] = Optional.Absent,
    instanceId: Optional[NonEmptyString] = Optional.Absent,
    instanceOwnerId: Optional[NonEmptyString] = Optional.Absent,
    localGatewayId: Optional[NonEmptyString] = Optional.Absent,
    natGatewayId: Optional[NonEmptyString] = Optional.Absent,
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent,
    origin: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[NonEmptyString] = Optional.Absent,
    transitGatewayId: Optional[NonEmptyString] = Optional.Absent,
    vpcPeeringConnectionId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RouteSetDetails = {
    import RouteSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RouteSetDetails
      .builder()
      .optionallyWith(
        carrierGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.carrierGatewayId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        destinationCidrBlock.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(
        gatewayId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        instanceOwnerId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceOwnerId)
      .optionallyWith(
        localGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.localGatewayId)
      .optionallyWith(
        natGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.natGatewayId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        origin.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.origin)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        transitGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RouteSetDetails.ReadOnly =
    zio.aws.securityhub.model.RouteSetDetails.wrap(buildAwsValue())
}
object RouteSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RouteSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RouteSetDetails =
      zio.aws.securityhub.model.RouteSetDetails(
        carrierGatewayId.map(value => value),
        coreNetworkArn.map(value => value),
        destinationCidrBlock.map(value => value),
        destinationIpv6CidrBlock.map(value => value),
        destinationPrefixListId.map(value => value),
        egressOnlyInternetGatewayId.map(value => value),
        gatewayId.map(value => value),
        instanceId.map(value => value),
        instanceOwnerId.map(value => value),
        localGatewayId.map(value => value),
        natGatewayId.map(value => value),
        networkInterfaceId.map(value => value),
        origin.map(value => value),
        state.map(value => value),
        transitGatewayId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def carrierGatewayId: Optional[NonEmptyString]
    def coreNetworkArn: Optional[NonEmptyString]
    def destinationCidrBlock: Optional[NonEmptyString]
    def destinationIpv6CidrBlock: Optional[NonEmptyString]
    def destinationPrefixListId: Optional[NonEmptyString]
    def egressOnlyInternetGatewayId: Optional[NonEmptyString]
    def gatewayId: Optional[NonEmptyString]
    def instanceId: Optional[NonEmptyString]
    def instanceOwnerId: Optional[NonEmptyString]
    def localGatewayId: Optional[NonEmptyString]
    def natGatewayId: Optional[NonEmptyString]
    def networkInterfaceId: Optional[NonEmptyString]
    def origin: Optional[NonEmptyString]
    def state: Optional[NonEmptyString]
    def transitGatewayId: Optional[NonEmptyString]
    def vpcPeeringConnectionId: Optional[NonEmptyString]
    def getCarrierGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("carrierGatewayId", carrierGatewayId)
    def getCoreNetworkArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getDestinationCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "destinationIpv6CidrBlock",
        destinationIpv6CidrBlock
      )
    def getDestinationPrefixListId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
    def getEgressOnlyInternetGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceOwnerId", instanceOwnerId)
    def getLocalGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getNatGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOrigin: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("origin", origin)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getTransitGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RouteSetDetails
  ) extends zio.aws.securityhub.model.RouteSetDetails.ReadOnly {
    override val carrierGatewayId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGatewayId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val coreNetworkArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val destinationCidrBlock: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationCidrBlock())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val destinationIpv6CidrBlock: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpv6CidrBlock())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val destinationPrefixListId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val egressOnlyInternetGatewayId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressOnlyInternetGatewayId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val gatewayId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceOwnerId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceOwnerId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val localGatewayId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val natGatewayId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val origin: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.origin())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val transitGatewayId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val vpcPeeringConnectionId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RouteSetDetails
  ): zio.aws.securityhub.model.RouteSetDetails.ReadOnly = new Wrapper(impl)
}
