package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait RegionAvailabilityStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus
}
object RegionAvailabilityStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus
  ): zio.aws.securityhub.model.RegionAvailabilityStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.RegionAvailabilityStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus =
      software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE
      extends zio.aws.securityhub.model.RegionAvailabilityStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus =
      software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus.AVAILABLE
  }
  case object UNAVAILABLE
      extends zio.aws.securityhub.model.RegionAvailabilityStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus =
      software.amazon.awssdk.services.securityhub.model.RegionAvailabilityStatus.UNAVAILABLE
  }
}
