package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PortProbeDetail(
    localPortDetails: Optional[
      zio.aws.securityhub.model.ActionLocalPortDetails
    ] = Optional.Absent,
    localIpDetails: Optional[zio.aws.securityhub.model.ActionLocalIpDetails] =
      Optional.Absent,
    remoteIpDetails: Optional[zio.aws.securityhub.model.ActionRemoteIpDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PortProbeDetail = {
    import PortProbeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PortProbeDetail
      .builder()
      .optionallyWith(localPortDetails.map(value => value.buildAwsValue()))(
        _.localPortDetails
      )
      .optionallyWith(localIpDetails.map(value => value.buildAwsValue()))(
        _.localIpDetails
      )
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PortProbeDetail.ReadOnly =
    zio.aws.securityhub.model.PortProbeDetail.wrap(buildAwsValue())
}
object PortProbeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PortProbeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PortProbeDetail =
      zio.aws.securityhub.model.PortProbeDetail(
        localPortDetails.map(value => value.asEditable),
        localIpDetails.map(value => value.asEditable),
        remoteIpDetails.map(value => value.asEditable)
      )
    def localPortDetails
        : Optional[zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly]
    def localIpDetails
        : Optional[zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly]
    def remoteIpDetails
        : Optional[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly]
    def getLocalPortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localPortDetails", localPortDetails)
    def getLocalIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localIpDetails", localIpDetails)
    def getRemoteIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PortProbeDetail
  ) extends zio.aws.securityhub.model.PortProbeDetail.ReadOnly {
    override val localPortDetails
        : Optional[zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localPortDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionLocalPortDetails.wrap(value)
        )
    override val localIpDetails
        : Optional[zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionLocalIpDetails.wrap(value)
        )
    override val remoteIpDetails
        : Optional[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PortProbeDetail
  ): zio.aws.securityhub.model.PortProbeDetail.ReadOnly = new Wrapper(impl)
}
