package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Network(
    direction: Optional[zio.aws.securityhub.model.NetworkDirection] =
      Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent,
    openPortRange: Optional[zio.aws.securityhub.model.PortRange] =
      Optional.Absent,
    sourceIpV4: Optional[NonEmptyString] = Optional.Absent,
    sourceIpV6: Optional[NonEmptyString] = Optional.Absent,
    sourcePort: Optional[Integer] = Optional.Absent,
    sourceDomain: Optional[NonEmptyString] = Optional.Absent,
    sourceMac: Optional[NonEmptyString] = Optional.Absent,
    destinationIpV4: Optional[NonEmptyString] = Optional.Absent,
    destinationIpV6: Optional[NonEmptyString] = Optional.Absent,
    destinationPort: Optional[Integer] = Optional.Absent,
    destinationDomain: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Network = {
    import Network.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Network
      .builder()
      .optionallyWith(direction.map(value => value.unwrap))(_.direction)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(openPortRange.map(value => value.buildAwsValue()))(
        _.openPortRange
      )
      .optionallyWith(
        sourceIpV4.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceIpV4)
      .optionallyWith(
        sourceIpV6.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceIpV6)
      .optionallyWith(sourcePort.map(value => value: java.lang.Integer))(
        _.sourcePort
      )
      .optionallyWith(
        sourceDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceDomain)
      .optionallyWith(
        sourceMac.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceMac)
      .optionallyWith(
        destinationIpV4.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationIpV4)
      .optionallyWith(
        destinationIpV6.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationIpV6)
      .optionallyWith(destinationPort.map(value => value: java.lang.Integer))(
        _.destinationPort
      )
      .optionallyWith(
        destinationDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationDomain)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Network.ReadOnly =
    zio.aws.securityhub.model.Network.wrap(buildAwsValue())
}
object Network {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Network
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Network =
      zio.aws.securityhub.model.Network(
        direction.map(value => value),
        protocol.map(value => value),
        openPortRange.map(value => value.asEditable),
        sourceIpV4.map(value => value),
        sourceIpV6.map(value => value),
        sourcePort.map(value => value),
        sourceDomain.map(value => value),
        sourceMac.map(value => value),
        destinationIpV4.map(value => value),
        destinationIpV6.map(value => value),
        destinationPort.map(value => value),
        destinationDomain.map(value => value)
      )
    def direction: Optional[zio.aws.securityhub.model.NetworkDirection]
    def protocol: Optional[NonEmptyString]
    def openPortRange: Optional[zio.aws.securityhub.model.PortRange.ReadOnly]
    def sourceIpV4: Optional[NonEmptyString]
    def sourceIpV6: Optional[NonEmptyString]
    def sourcePort: Optional[Integer]
    def sourceDomain: Optional[NonEmptyString]
    def sourceMac: Optional[NonEmptyString]
    def destinationIpV4: Optional[NonEmptyString]
    def destinationIpV6: Optional[NonEmptyString]
    def destinationPort: Optional[Integer]
    def destinationDomain: Optional[NonEmptyString]
    def getDirection
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NetworkDirection] =
      AwsError.unwrapOptionField("direction", direction)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getOpenPortRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("openPortRange", openPortRange)
    def getSourceIpV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceIpV4", sourceIpV4)
    def getSourceIpV6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceIpV6", sourceIpV6)
    def getSourcePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sourcePort", sourcePort)
    def getSourceDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceDomain", sourceDomain)
    def getSourceMac: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceMac", sourceMac)
    def getDestinationIpV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationIpV4", destinationIpV4)
    def getDestinationIpV6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationIpV6", destinationIpV6)
    def getDestinationPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getDestinationDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationDomain", destinationDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Network
  ) extends zio.aws.securityhub.model.Network.ReadOnly {
    override val direction
        : Optional[zio.aws.securityhub.model.NetworkDirection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.direction())
        .map(value => zio.aws.securityhub.model.NetworkDirection.wrap(value))
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val openPortRange
        : Optional[zio.aws.securityhub.model.PortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openPortRange())
        .map(value => zio.aws.securityhub.model.PortRange.wrap(value))
    override val sourceIpV4: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIpV4())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceIpV6: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIpV6())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourcePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePort())
      .map(value => value: Integer)
    override val sourceDomain: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDomain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceMac: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceMac())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationIpV4: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpV4())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val destinationIpV6: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpV6())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val destinationPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationPort())
      .map(value => value: Integer)
    override val destinationDomain: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationDomain())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Network
  ): zio.aws.securityhub.model.Network.ReadOnly = new Wrapper(impl)
}
