package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAutomationRulesResponse(
    automationRulesMetadata: Optional[
      Iterable[zio.aws.securityhub.model.AutomationRulesMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListAutomationRulesResponse = {
    import ListAutomationRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListAutomationRulesResponse
      .builder()
      .optionallyWith(
        automationRulesMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.automationRulesMetadata)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListAutomationRulesResponse.ReadOnly =
    zio.aws.securityhub.model.ListAutomationRulesResponse.wrap(buildAwsValue())
}
object ListAutomationRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListAutomationRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListAutomationRulesResponse =
      zio.aws.securityhub.model.ListAutomationRulesResponse(
        automationRulesMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def automationRulesMetadata: Optional[
      List[zio.aws.securityhub.model.AutomationRulesMetadata.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getAutomationRulesMetadata: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AutomationRulesMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "automationRulesMetadata",
      automationRulesMetadata
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListAutomationRulesResponse
  ) extends zio.aws.securityhub.model.ListAutomationRulesResponse.ReadOnly {
    override val automationRulesMetadata: Optional[
      List[zio.aws.securityhub.model.AutomationRulesMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.automationRulesMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AutomationRulesMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListAutomationRulesResponse
  ): zio.aws.securityhub.model.ListAutomationRulesResponse.ReadOnly =
    new Wrapper(impl)
}
