package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAutomationRulesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest = {
    import ListAutomationRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListAutomationRulesRequest.ReadOnly =
    zio.aws.securityhub.model.ListAutomationRulesRequest.wrap(buildAwsValue())
}
object ListAutomationRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListAutomationRulesRequest =
      zio.aws.securityhub.model.ListAutomationRulesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest
  ) extends zio.aws.securityhub.model.ListAutomationRulesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest
  ): zio.aws.securityhub.model.ListAutomationRulesRequest.ReadOnly =
    new Wrapper(impl)
}
