package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetInsightResultsRequest(insightArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest = {
    import GetInsightResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest
      .builder()
      .insightArn(NonEmptyString.unwrap(insightArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetInsightResultsRequest.ReadOnly =
    zio.aws.securityhub.model.GetInsightResultsRequest.wrap(buildAwsValue())
}
object GetInsightResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetInsightResultsRequest =
      zio.aws.securityhub.model.GetInsightResultsRequest(insightArn)
    def insightArn: NonEmptyString
    def getInsightArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(insightArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest
  ) extends zio.aws.securityhub.model.GetInsightResultsRequest.ReadOnly {
    override val insightArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.insightArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest
  ): zio.aws.securityhub.model.GetInsightResultsRequest.ReadOnly = new Wrapper(
    impl
  )
}
