package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFindingHistoryResponse(
    records: Optional[
      Iterable[zio.aws.securityhub.model.FindingHistoryRecord]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse = {
    import GetFindingHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse
      .builder()
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetFindingHistoryResponse.ReadOnly =
    zio.aws.securityhub.model.GetFindingHistoryResponse.wrap(buildAwsValue())
}
object GetFindingHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetFindingHistoryResponse =
      zio.aws.securityhub.model.GetFindingHistoryResponse(
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def records: Optional[
      List[zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getRecords: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("records", records)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse
  ) extends zio.aws.securityhub.model.GetFindingHistoryResponse.ReadOnly {
    override val records: Optional[
      List[zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.records())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FindingHistoryRecord.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse
  ): zio.aws.securityhub.model.GetFindingHistoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
