package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{NextToken, Timestamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FindingHistoryRecord(
    findingIdentifier: Optional[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier
    ] = Optional.Absent,
    updateTime: Optional[Timestamp] = Optional.Absent,
    findingCreated: Optional[Boolean] = Optional.Absent,
    updateSource: Optional[
      zio.aws.securityhub.model.FindingHistoryUpdateSource
    ] = Optional.Absent,
    updates: Optional[
      Iterable[zio.aws.securityhub.model.FindingHistoryUpdate]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord = {
    import FindingHistoryRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord
      .builder()
      .optionallyWith(findingIdentifier.map(value => value.buildAwsValue()))(
        _.findingIdentifier
      )
      .optionallyWith(
        updateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateTime)
      .optionallyWith(findingCreated.map(value => value: java.lang.Boolean))(
        _.findingCreated
      )
      .optionallyWith(updateSource.map(value => value.buildAwsValue()))(
        _.updateSource
      )
      .optionallyWith(
        updates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly =
    zio.aws.securityhub.model.FindingHistoryRecord.wrap(buildAwsValue())
}
object FindingHistoryRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FindingHistoryRecord =
      zio.aws.securityhub.model.FindingHistoryRecord(
        findingIdentifier.map(value => value.asEditable),
        updateTime.map(value => value),
        findingCreated.map(value => value),
        updateSource.map(value => value.asEditable),
        updates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findingIdentifier: Optional[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ]
    def updateTime: Optional[Timestamp]
    def findingCreated: Optional[Boolean]
    def updateSource: Optional[
      zio.aws.securityhub.model.FindingHistoryUpdateSource.ReadOnly
    ]
    def updates: Optional[
      List[zio.aws.securityhub.model.FindingHistoryUpdate.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getFindingIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("findingIdentifier", findingIdentifier)
    def getUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateTime", updateTime)
    def getFindingCreated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("findingCreated", findingCreated)
    def getUpdateSource: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.FindingHistoryUpdateSource.ReadOnly
    ] = AwsError.unwrapOptionField("updateSource", updateSource)
    def getUpdates: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FindingHistoryUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("updates", updates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord
  ) extends zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly {
    override val findingIdentifier: Optional[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.findingIdentifier())
      .map(value =>
        zio.aws.securityhub.model.AwsSecurityFindingIdentifier.wrap(value)
      )
    override val updateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val findingCreated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.findingCreated())
      .map(value => value: Boolean)
    override val updateSource: Optional[
      zio.aws.securityhub.model.FindingHistoryUpdateSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateSource())
      .map(value =>
        zio.aws.securityhub.model.FindingHistoryUpdateSource.wrap(value)
      )
    override val updates: Optional[
      List[zio.aws.securityhub.model.FindingHistoryUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FindingHistoryUpdate.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord
  ): zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly = new Wrapper(impl)
}
