package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableImportFindingsForProductRequest(
    productArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest = {
    import EnableImportFindingsForProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest
      .builder()
      .productArn(NonEmptyString.unwrap(productArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.EnableImportFindingsForProductRequest.ReadOnly =
    zio.aws.securityhub.model.EnableImportFindingsForProductRequest
      .wrap(buildAwsValue())
}
object EnableImportFindingsForProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.EnableImportFindingsForProductRequest =
      zio.aws.securityhub.model
        .EnableImportFindingsForProductRequest(productArn)
    def productArn: NonEmptyString
    def getProductArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(productArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest
  ) extends zio.aws.securityhub.model.EnableImportFindingsForProductRequest.ReadOnly {
    override val productArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.productArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest
  ): zio.aws.securityhub.model.EnableImportFindingsForProductRequest.ReadOnly =
    new Wrapper(impl)
}
