package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisableStandardsResponse(
    standardsSubscriptions: Optional[
      Iterable[zio.aws.securityhub.model.StandardsSubscription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse = {
    import BatchDisableStandardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse
      .builder()
      .optionallyWith(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standardsSubscriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchDisableStandardsResponse
      .wrap(buildAwsValue())
}
object BatchDisableStandardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchDisableStandardsResponse =
      zio.aws.securityhub.model.BatchDisableStandardsResponse(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def standardsSubscriptions: Optional[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ]
    def getStandardsSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StandardsSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "standardsSubscriptions",
      standardsSubscriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse
  ) extends zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly {
    override val standardsSubscriptions: Optional[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.standardsSubscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StandardsSubscription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse
  ): zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly =
    new Wrapper(impl)
}
