package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2RulesActionDetails(
    allow: Optional[zio.aws.securityhub.model.AwsWafv2ActionAllowDetails] =
      Optional.Absent,
    block: Optional[zio.aws.securityhub.model.AwsWafv2ActionBlockDetails] =
      Optional.Absent,
    captcha: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails
    ] = Optional.Absent,
    count: Optional[zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionDetails = {
    import AwsWafv2RulesActionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionDetails
      .builder()
      .optionallyWith(allow.map(value => value.buildAwsValue()))(_.allow)
      .optionallyWith(block.map(value => value.buildAwsValue()))(_.block)
      .optionallyWith(captcha.map(value => value.buildAwsValue()))(_.captcha)
      .optionallyWith(count.map(value => value.buildAwsValue()))(_.count)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2RulesActionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2RulesActionDetails.wrap(buildAwsValue())
}
object AwsWafv2RulesActionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2RulesActionDetails =
      zio.aws.securityhub.model.AwsWafv2RulesActionDetails(
        allow.map(value => value.asEditable),
        block.map(value => value.asEditable),
        captcha.map(value => value.asEditable),
        count.map(value => value.asEditable)
      )
    def allow: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly
    ]
    def block: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly
    ]
    def captcha: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.ReadOnly
    ]
    def count: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.ReadOnly
    ]
    def getAllow: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly
    ] = AwsError.unwrapOptionField("allow", allow)
    def getBlock: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly
    ] = AwsError.unwrapOptionField("block", block)
    def getCaptcha: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.ReadOnly
    ] = AwsError.unwrapOptionField("captcha", captcha)
    def getCount: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.ReadOnly
    ] = AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionDetails
  ) extends zio.aws.securityhub.model.AwsWafv2RulesActionDetails.ReadOnly {
    override val allow: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.allow())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.wrap(value)
      )
    override val block: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.block())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.wrap(value)
      )
    override val captcha: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.captcha())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2RulesActionCaptchaDetails.wrap(value)
      )
    override val count: Optional[
      zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2RulesActionCountDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesActionDetails
  ): zio.aws.securityhub.model.AwsWafv2RulesActionDetails.ReadOnly =
    new Wrapper(impl)
}
