package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2ActionAllowDetails(
    customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionAllowDetails = {
    import AwsWafv2ActionAllowDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionAllowDetails
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.wrap(buildAwsValue())
}
object AwsWafv2ActionAllowDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionAllowDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2ActionAllowDetails =
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails(
        customRequestHandling.map(value => value.asEditable)
      )
    def customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionAllowDetails
  ) extends zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly {
    override val customRequestHandling: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customRequestHandling())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionAllowDetails
  ): zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly =
    new Wrapper(impl)
}
