package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafWebAclDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    defaultAction: Optional[NonEmptyString] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.securityhub.model.AwsWafWebAclRule]] =
      Optional.Absent,
    webAclId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafWebAclDetails = {
    import AwsWafWebAclDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafWebAclDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        defaultAction.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultAction)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        webAclId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.webAclId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafWebAclDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafWebAclDetails.wrap(buildAwsValue())
}
object AwsWafWebAclDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafWebAclDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafWebAclDetails =
      zio.aws.securityhub.model.AwsWafWebAclDetails(
        name.map(value => value),
        defaultAction.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        webAclId.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def defaultAction: Optional[NonEmptyString]
    def rules
        : Optional[List[zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly]]
    def webAclId: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultAction", defaultAction)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getWebAclId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("webAclId", webAclId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafWebAclDetails
  ) extends zio.aws.securityhub.model.AwsWafWebAclDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultAction: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultAction())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rules
        : Optional[List[zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsWafWebAclRule.wrap(item)
          }.toList
        )
    override val webAclId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.webAclId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafWebAclDetails
  ): zio.aws.securityhub.model.AwsWafWebAclDetails.ReadOnly = new Wrapper(impl)
}
