package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsStepFunctionStateMachineTracingConfigurationDetails(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails = {
    import AwsStepFunctionStateMachineTracingConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsStepFunctionStateMachineTracingConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails =
      zio.aws.securityhub.model
        .AwsStepFunctionStateMachineTracingConfigurationDetails(
          enabled.map(value => value)
        )
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
  ): zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
