package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsStepFunctionStateMachineDetails(
    label: Optional[NonEmptyString] = Optional.Absent,
    loggingConfiguration: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    stateMachineArn: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    tracingConfiguration: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
    ] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineDetails = {
    import AwsStepFunctionStateMachineDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineDetails
      .builder()
      .optionallyWith(
        label.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        stateMachineArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.stateMachineArn)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsStepFunctionStateMachineDetails.ReadOnly =
    zio.aws.securityhub.model.AwsStepFunctionStateMachineDetails
      .wrap(buildAwsValue())
}
object AwsStepFunctionStateMachineDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsStepFunctionStateMachineDetails =
      zio.aws.securityhub.model.AwsStepFunctionStateMachineDetails(
        label.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        name.map(value => value),
        roleArn.map(value => value),
        stateMachineArn.map(value => value),
        status.map(value => value),
        tracingConfiguration.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def label: Optional[NonEmptyString]
    def loggingConfiguration: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails.ReadOnly
    ]
    def name: Optional[NonEmptyString]
    def roleArn: Optional[NonEmptyString]
    def stateMachineArn: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def tracingConfiguration: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails.ReadOnly
    ]
    def `type`: Optional[NonEmptyString]
    def getLabel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("label", label)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStateMachineArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stateMachineArn", stateMachineArn)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getTracingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineDetails
  ) extends zio.aws.securityhub.model.AwsStepFunctionStateMachineDetails.ReadOnly {
    override val label: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val loggingConfiguration: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
          .wrap(value)
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stateMachineArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateMachineArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tracingConfiguration: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tracingConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsStepFunctionStateMachineTracingConfigurationDetails
          .wrap(value)
      )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineDetails
  ): zio.aws.securityhub.model.AwsStepFunctionStateMachineDetails.ReadOnly =
    new Wrapper(impl)
}
