package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSecurityFindingFilters(
    productArn: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    awsAccountId: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    id: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    generatorId: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    region: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    `type`: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    firstObservedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    lastObservedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    createdAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    updatedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    severityProduct: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    severityNormalized: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    severityLabel: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    confidence: Optional[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      Optional.Absent,
    criticality: Optional[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      Optional.Absent,
    title: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    description: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    recommendationText: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    sourceUrl: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    productFields: Optional[Iterable[zio.aws.securityhub.model.MapFilter]] =
      Optional.Absent,
    productName: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    companyName: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    userDefinedFields: Optional[Iterable[zio.aws.securityhub.model.MapFilter]] =
      Optional.Absent,
    malwareName: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    malwareType: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    malwarePath: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    malwareState: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    networkDirection: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    networkProtocol: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    networkSourceIpV4: Optional[Iterable[zio.aws.securityhub.model.IpFilter]] =
      Optional.Absent,
    networkSourceIpV6: Optional[Iterable[zio.aws.securityhub.model.IpFilter]] =
      Optional.Absent,
    networkSourcePort: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    networkSourceDomain: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    networkSourceMac: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    networkDestinationIpV4: Optional[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = Optional.Absent,
    networkDestinationIpV6: Optional[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = Optional.Absent,
    networkDestinationPort: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    networkDestinationDomain: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    processName: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    processPath: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    processPid: Optional[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      Optional.Absent,
    processParentPid: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    processLaunchedAt: Optional[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = Optional.Absent,
    processTerminatedAt: Optional[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = Optional.Absent,
    threatIntelIndicatorType: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    threatIntelIndicatorValue: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    threatIntelIndicatorCategory: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    threatIntelIndicatorLastObservedAt: Optional[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = Optional.Absent,
    threatIntelIndicatorSource: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    threatIntelIndicatorSourceUrl: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceType: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourceId: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourcePartition: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceRegion: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.securityhub.model.MapFilter]] =
      Optional.Absent,
    resourceAwsEc2InstanceType: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceImageId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceIpV4Addresses: Optional[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceIpV6Addresses: Optional[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceKeyName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceIamInstanceProfileArn: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceVpcId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceSubnetId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsEc2InstanceLaunchedAt: Optional[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = Optional.Absent,
    resourceAwsS3BucketOwnerId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsS3BucketOwnerName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsIamAccessKeyUserName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsIamAccessKeyPrincipalName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsIamAccessKeyStatus: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceAwsIamAccessKeyCreatedAt: Optional[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = Optional.Absent,
    resourceAwsIamUserUserName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceContainerName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceContainerImageId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceContainerImageName: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceContainerLaunchedAt: Optional[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = Optional.Absent,
    resourceDetailsOther: Optional[
      Iterable[zio.aws.securityhub.model.MapFilter]
    ] = Optional.Absent,
    complianceStatus: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    verificationState: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    workflowState: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    workflowStatus: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    recordState: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    relatedFindingsProductArn: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    relatedFindingsId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    noteText: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    noteUpdatedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    noteUpdatedBy: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    keyword: Optional[Iterable[zio.aws.securityhub.model.KeywordFilter]] =
      Optional.Absent,
    findingProviderFieldsConfidence: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    findingProviderFieldsCriticality: Optional[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = Optional.Absent,
    findingProviderFieldsRelatedFindingsId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    findingProviderFieldsRelatedFindingsProductArn: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    findingProviderFieldsSeverityLabel: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    findingProviderFieldsSeverityOriginal: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    findingProviderFieldsTypes: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    sample: Optional[Iterable[zio.aws.securityhub.model.BooleanFilter]] =
      Optional.Absent,
    complianceSecurityControlId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    complianceAssociatedStandardsId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters = {
    import AwsSecurityFindingFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
      .builder()
      .optionallyWith(
        productArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productArn)
      .optionallyWith(
        awsAccountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccountId)
      .optionallyWith(
        id.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.id)
      .optionallyWith(
        generatorId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatorId)
      .optionallyWith(
        region.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.region)
      .optionallyWith(
        `type`.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.`type`)
      .optionallyWith(
        firstObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firstObservedAt)
      .optionallyWith(
        lastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastObservedAt)
      .optionallyWith(
        createdAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createdAt)
      .optionallyWith(
        updatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updatedAt)
      .optionallyWith(
        severityProduct.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityProduct)
      .optionallyWith(
        severityNormalized.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityNormalized)
      .optionallyWith(
        severityLabel.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLabel)
      .optionallyWith(
        confidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.confidence)
      .optionallyWith(
        criticality.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.criticality)
      .optionallyWith(
        title.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.title)
      .optionallyWith(
        description.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.description)
      .optionallyWith(
        recommendationText.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationText)
      .optionallyWith(
        sourceUrl.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceUrl)
      .optionallyWith(
        productFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productFields)
      .optionallyWith(
        productName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productName)
      .optionallyWith(
        companyName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.companyName)
      .optionallyWith(
        userDefinedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userDefinedFields)
      .optionallyWith(
        malwareName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwareName)
      .optionallyWith(
        malwareType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwareType)
      .optionallyWith(
        malwarePath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwarePath)
      .optionallyWith(
        malwareState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwareState)
      .optionallyWith(
        networkDirection.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDirection)
      .optionallyWith(
        networkProtocol.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProtocol)
      .optionallyWith(
        networkSourceIpV4.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceIpV4)
      .optionallyWith(
        networkSourceIpV6.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceIpV6)
      .optionallyWith(
        networkSourcePort.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourcePort)
      .optionallyWith(
        networkSourceDomain.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceDomain)
      .optionallyWith(
        networkSourceMac.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceMac)
      .optionallyWith(
        networkDestinationIpV4.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationIpV4)
      .optionallyWith(
        networkDestinationIpV6.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationIpV6)
      .optionallyWith(
        networkDestinationPort.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationPort)
      .optionallyWith(
        networkDestinationDomain.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationDomain)
      .optionallyWith(
        processName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processName)
      .optionallyWith(
        processPath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processPath)
      .optionallyWith(
        processPid.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processPid)
      .optionallyWith(
        processParentPid.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processParentPid)
      .optionallyWith(
        processLaunchedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processLaunchedAt)
      .optionallyWith(
        processTerminatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processTerminatedAt)
      .optionallyWith(
        threatIntelIndicatorType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorType)
      .optionallyWith(
        threatIntelIndicatorValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorValue)
      .optionallyWith(
        threatIntelIndicatorCategory.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorCategory)
      .optionallyWith(
        threatIntelIndicatorLastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorLastObservedAt)
      .optionallyWith(
        threatIntelIndicatorSource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorSource)
      .optionallyWith(
        threatIntelIndicatorSourceUrl.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorSourceUrl)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourcePartition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcePartition)
      .optionallyWith(
        resourceRegion.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRegion)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(
        resourceAwsEc2InstanceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceType)
      .optionallyWith(
        resourceAwsEc2InstanceImageId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceImageId)
      .optionallyWith(
        resourceAwsEc2InstanceIpV4Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceIpV4Addresses)
      .optionallyWith(
        resourceAwsEc2InstanceIpV6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceIpV6Addresses)
      .optionallyWith(
        resourceAwsEc2InstanceKeyName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceKeyName)
      .optionallyWith(
        resourceAwsEc2InstanceIamInstanceProfileArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceIamInstanceProfileArn)
      .optionallyWith(
        resourceAwsEc2InstanceVpcId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceVpcId)
      .optionallyWith(
        resourceAwsEc2InstanceSubnetId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceSubnetId)
      .optionallyWith(
        resourceAwsEc2InstanceLaunchedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceLaunchedAt)
      .optionallyWith(
        resourceAwsS3BucketOwnerId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsS3BucketOwnerId)
      .optionallyWith(
        resourceAwsS3BucketOwnerName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsS3BucketOwnerName)
      .optionallyWith(
        resourceAwsIamAccessKeyUserName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyUserName)
      .optionallyWith(
        resourceAwsIamAccessKeyPrincipalName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyPrincipalName)
      .optionallyWith(
        resourceAwsIamAccessKeyStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyStatus)
      .optionallyWith(
        resourceAwsIamAccessKeyCreatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyCreatedAt)
      .optionallyWith(
        resourceAwsIamUserUserName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamUserUserName)
      .optionallyWith(
        resourceContainerName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerName)
      .optionallyWith(
        resourceContainerImageId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerImageId)
      .optionallyWith(
        resourceContainerImageName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerImageName)
      .optionallyWith(
        resourceContainerLaunchedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerLaunchedAt)
      .optionallyWith(
        resourceDetailsOther.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDetailsOther)
      .optionallyWith(
        complianceStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceStatus)
      .optionallyWith(
        verificationState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verificationState)
      .optionallyWith(
        workflowState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowState)
      .optionallyWith(
        workflowStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowStatus)
      .optionallyWith(
        recordState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordState)
      .optionallyWith(
        relatedFindingsProductArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindingsProductArn)
      .optionallyWith(
        relatedFindingsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindingsId)
      .optionallyWith(
        noteText.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteText)
      .optionallyWith(
        noteUpdatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteUpdatedAt)
      .optionallyWith(
        noteUpdatedBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteUpdatedBy)
      .optionallyWith(
        keyword.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyword)
      .optionallyWith(
        findingProviderFieldsConfidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsConfidence)
      .optionallyWith(
        findingProviderFieldsCriticality.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsCriticality)
      .optionallyWith(
        findingProviderFieldsRelatedFindingsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsRelatedFindingsId)
      .optionallyWith(
        findingProviderFieldsRelatedFindingsProductArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsRelatedFindingsProductArn)
      .optionallyWith(
        findingProviderFieldsSeverityLabel.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsSeverityLabel)
      .optionallyWith(
        findingProviderFieldsSeverityOriginal.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsSeverityOriginal)
      .optionallyWith(
        findingProviderFieldsTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsTypes)
      .optionallyWith(
        sample.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sample)
      .optionallyWith(
        complianceSecurityControlId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceSecurityControlId)
      .optionallyWith(
        complianceAssociatedStandardsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceAssociatedStandardsId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly =
    zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(buildAwsValue())
}
object AwsSecurityFindingFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSecurityFindingFilters =
      zio.aws.securityhub.model.AwsSecurityFindingFilters(
        productArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        awsAccountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        generatorId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        region.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firstObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityProduct.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityNormalized.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityLabel.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        confidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        criticality.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        title.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationText.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceUrl.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        companyName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userDefinedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwareName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwareType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwarePath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwareState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDirection.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkProtocol.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceIpV4.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceIpV6.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourcePort.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceDomain.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceMac.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationIpV4.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationIpV6.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationPort.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationDomain.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processPath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processPid.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processParentPid.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processLaunchedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processTerminatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorCategory.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorLastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorSource.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorSourceUrl.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourcePartition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRegion.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceImageId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceIpV4Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceIpV6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceKeyName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceIamInstanceProfileArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceVpcId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceSubnetId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceLaunchedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsS3BucketOwnerId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsS3BucketOwnerName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyUserName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyPrincipalName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyCreatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamUserUserName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerImageId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerImageName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerLaunchedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceDetailsOther.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        verificationState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recordState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedFindingsProductArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedFindingsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteText.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteUpdatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteUpdatedBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyword.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsConfidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsCriticality.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsRelatedFindingsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsRelatedFindingsProductArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsSeverityLabel.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsSeverityOriginal.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sample.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceSecurityControlId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceAssociatedStandardsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def awsAccountId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def id: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def generatorId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def region: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def `type`: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def firstObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def lastObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def createdAt: Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def updatedAt: Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def severityProduct
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def severityNormalized
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def severityLabel
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def confidence
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def criticality
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def title: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def description
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def recommendationText
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def sourceUrl
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def productFields
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def productName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def companyName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def userDefinedFields
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def malwareName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def malwareType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def malwarePath
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def malwareState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkDirection
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkProtocol
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkSourceIpV4
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkSourceIpV6
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkSourcePort
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def networkSourceDomain
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkSourceMac
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkDestinationIpV4
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkDestinationIpV6
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkDestinationPort
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def networkDestinationDomain
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def processName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def processPath
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def processPid
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def processParentPid
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def processLaunchedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def processTerminatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def threatIntelIndicatorType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorValue
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorCategory
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorLastObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def threatIntelIndicatorSource
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorSourceUrl
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourcePartition
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceRegion
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceTags
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def resourceAwsEc2InstanceType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceImageId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceIpV4Addresses
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def resourceAwsEc2InstanceIpV6Addresses
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def resourceAwsEc2InstanceKeyName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceIamInstanceProfileArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceVpcId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceSubnetId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceLaunchedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def resourceAwsS3BucketOwnerId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsS3BucketOwnerName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyUserName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyPrincipalName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyCreatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def resourceAwsIamUserUserName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerImageId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerImageName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerLaunchedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def resourceDetailsOther
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def complianceStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def verificationState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def workflowState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def workflowStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def recordState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def relatedFindingsProductArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def relatedFindingsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def noteText
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def noteUpdatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def noteUpdatedBy
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def keyword
        : Optional[List[zio.aws.securityhub.model.KeywordFilter.ReadOnly]]
    def findingProviderFieldsConfidence
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def findingProviderFieldsCriticality
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def findingProviderFieldsRelatedFindingsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsRelatedFindingsProductArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsSeverityLabel
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsSeverityOriginal
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsTypes
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def sample: Optional[List[zio.aws.securityhub.model.BooleanFilter.ReadOnly]]
    def complianceSecurityControlId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def complianceAssociatedStandardsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def getProductArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productArn", productArn)
    def getAwsAccountId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("id", id)
    def getGeneratorId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("generatorId", generatorId)
    def getRegion: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("region", region)
    def getType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("type", `type`)
    def getFirstObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getCreatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getSeverityProduct: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityProduct", severityProduct)
    def getSeverityNormalized: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityNormalized", severityNormalized)
    def getSeverityLabel: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLabel", severityLabel)
    def getConfidence: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("criticality", criticality)
    def getTitle: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("description", description)
    def getRecommendationText: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendationText", recommendationText)
    def getSourceUrl: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getProductFields: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productFields", productFields)
    def getProductName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productName", productName)
    def getCompanyName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("companyName", companyName)
    def getUserDefinedFields: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("userDefinedFields", userDefinedFields)
    def getMalwareName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwareName", malwareName)
    def getMalwareType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwareType", malwareType)
    def getMalwarePath: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwarePath", malwarePath)
    def getMalwareState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwareState", malwareState)
    def getNetworkDirection: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkDirection", networkDirection)
    def getNetworkProtocol: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProtocol", networkProtocol)
    def getNetworkSourceIpV4: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceIpV4", networkSourceIpV4)
    def getNetworkSourceIpV6: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceIpV6", networkSourceIpV6)
    def getNetworkSourcePort: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourcePort", networkSourcePort)
    def getNetworkSourceDomain: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceDomain", networkSourceDomain)
    def getNetworkSourceMac: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceMac", networkSourceMac)
    def getNetworkDestinationIpV4: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationIpV4",
      networkDestinationIpV4
    )
    def getNetworkDestinationIpV6: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationIpV6",
      networkDestinationIpV6
    )
    def getNetworkDestinationPort: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationPort",
      networkDestinationPort
    )
    def getNetworkDestinationDomain: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationDomain",
      networkDestinationDomain
    )
    def getProcessName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processName", processName)
    def getProcessPath: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processPath", processPath)
    def getProcessPid: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processPid", processPid)
    def getProcessParentPid: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processParentPid", processParentPid)
    def getProcessLaunchedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processLaunchedAt", processLaunchedAt)
    def getProcessTerminatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processTerminatedAt", processTerminatedAt)
    def getThreatIntelIndicatorType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorType",
      threatIntelIndicatorType
    )
    def getThreatIntelIndicatorValue: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorValue",
      threatIntelIndicatorValue
    )
    def getThreatIntelIndicatorCategory: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorCategory",
      threatIntelIndicatorCategory
    )
    def getThreatIntelIndicatorLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorLastObservedAt",
      threatIntelIndicatorLastObservedAt
    )
    def getThreatIntelIndicatorSource: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorSource",
      threatIntelIndicatorSource
    )
    def getThreatIntelIndicatorSourceUrl: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorSourceUrl",
      threatIntelIndicatorSourceUrl
    )
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourcePartition: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourcePartition", resourcePartition)
    def getResourceRegion: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getResourceAwsEc2InstanceType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceType",
      resourceAwsEc2InstanceType
    )
    def getResourceAwsEc2InstanceImageId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceImageId",
      resourceAwsEc2InstanceImageId
    )
    def getResourceAwsEc2InstanceIpV4Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceIpV4Addresses",
      resourceAwsEc2InstanceIpV4Addresses
    )
    def getResourceAwsEc2InstanceIpV6Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceIpV6Addresses",
      resourceAwsEc2InstanceIpV6Addresses
    )
    def getResourceAwsEc2InstanceKeyName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceKeyName",
      resourceAwsEc2InstanceKeyName
    )
    def getResourceAwsEc2InstanceIamInstanceProfileArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceIamInstanceProfileArn",
      resourceAwsEc2InstanceIamInstanceProfileArn
    )
    def getResourceAwsEc2InstanceVpcId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceVpcId",
      resourceAwsEc2InstanceVpcId
    )
    def getResourceAwsEc2InstanceSubnetId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceSubnetId",
      resourceAwsEc2InstanceSubnetId
    )
    def getResourceAwsEc2InstanceLaunchedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceLaunchedAt",
      resourceAwsEc2InstanceLaunchedAt
    )
    def getResourceAwsS3BucketOwnerId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsS3BucketOwnerId",
      resourceAwsS3BucketOwnerId
    )
    def getResourceAwsS3BucketOwnerName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsS3BucketOwnerName",
      resourceAwsS3BucketOwnerName
    )
    def getResourceAwsIamAccessKeyUserName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyUserName",
      resourceAwsIamAccessKeyUserName
    )
    def getResourceAwsIamAccessKeyPrincipalName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyPrincipalName",
      resourceAwsIamAccessKeyPrincipalName
    )
    def getResourceAwsIamAccessKeyStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyStatus",
      resourceAwsIamAccessKeyStatus
    )
    def getResourceAwsIamAccessKeyCreatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyCreatedAt",
      resourceAwsIamAccessKeyCreatedAt
    )
    def getResourceAwsIamUserUserName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamUserUserName",
      resourceAwsIamUserUserName
    )
    def getResourceContainerName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceContainerName", resourceContainerName)
    def getResourceContainerImageId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceContainerImageId",
      resourceContainerImageId
    )
    def getResourceContainerImageName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceContainerImageName",
      resourceContainerImageName
    )
    def getResourceContainerLaunchedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceContainerLaunchedAt",
      resourceContainerLaunchedAt
    )
    def getResourceDetailsOther: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceDetailsOther", resourceDetailsOther)
    def getComplianceStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("complianceStatus", complianceStatus)
    def getVerificationState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("verificationState", verificationState)
    def getWorkflowState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowState", workflowState)
    def getWorkflowStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowStatus", workflowStatus)
    def getRecordState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("recordState", recordState)
    def getRelatedFindingsProductArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relatedFindingsProductArn",
      relatedFindingsProductArn
    )
    def getRelatedFindingsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindingsId", relatedFindingsId)
    def getNoteText: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteText", noteText)
    def getNoteUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteUpdatedAt", noteUpdatedAt)
    def getNoteUpdatedBy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteUpdatedBy", noteUpdatedBy)
    def getKeyword: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.KeywordFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("keyword", keyword)
    def getFindingProviderFieldsConfidence: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsConfidence",
      findingProviderFieldsConfidence
    )
    def getFindingProviderFieldsCriticality: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsCriticality",
      findingProviderFieldsCriticality
    )
    def getFindingProviderFieldsRelatedFindingsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsRelatedFindingsId",
      findingProviderFieldsRelatedFindingsId
    )
    def getFindingProviderFieldsRelatedFindingsProductArn
        : ZIO[Any, AwsError, List[
          zio.aws.securityhub.model.StringFilter.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsRelatedFindingsProductArn",
      findingProviderFieldsRelatedFindingsProductArn
    )
    def getFindingProviderFieldsSeverityLabel: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsSeverityLabel",
      findingProviderFieldsSeverityLabel
    )
    def getFindingProviderFieldsSeverityOriginal: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsSeverityOriginal",
      findingProviderFieldsSeverityOriginal
    )
    def getFindingProviderFieldsTypes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsTypes",
      findingProviderFieldsTypes
    )
    def getSample: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.BooleanFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("sample", sample)
    def getComplianceSecurityControlId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceSecurityControlId",
      complianceSecurityControlId
    )
    def getComplianceAssociatedStandardsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceAssociatedStandardsId",
      complianceAssociatedStandardsId
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
  ) extends zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly {
    override val productArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productArn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val awsAccountId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val id
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val generatorId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generatorId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val region
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val `type`
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val firstObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val lastObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val createdAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val updatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val severityProduct
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityProduct())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val severityNormalized
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityNormalized())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val severityLabel
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityLabel())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val confidence
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confidence())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val criticality
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.criticality())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val title
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.title())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val description
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val recommendationText
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationText())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val sourceUrl
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceUrl())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val productFields
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
    override val productName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val companyName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.companyName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val userDefinedFields
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDefinedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
    override val malwareName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.malwareName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val malwareType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.malwareType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val malwarePath
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.malwarePath())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val malwareState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.malwareState())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val networkDirection
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkDirection())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val networkProtocol
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProtocol())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val networkSourceIpV4
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSourceIpV4())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.IpFilter.wrap(item)
          }.toList
        )
    override val networkSourceIpV6
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSourceIpV6())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.IpFilter.wrap(item)
          }.toList
        )
    override val networkSourcePort
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSourcePort())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val networkSourceDomain
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSourceDomain())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val networkSourceMac
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSourceMac())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val networkDestinationIpV4
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkDestinationIpV4())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.IpFilter.wrap(item)
          }.toList
        )
    override val networkDestinationIpV6
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkDestinationIpV6())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.IpFilter.wrap(item)
          }.toList
        )
    override val networkDestinationPort
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkDestinationPort())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val networkDestinationDomain
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkDestinationDomain())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val processName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val processPath
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processPath())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val processPid
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processPid())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val processParentPid
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processParentPid())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val processLaunchedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processLaunchedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val processTerminatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processTerminatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val threatIntelIndicatorType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatIntelIndicatorType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val threatIntelIndicatorValue
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatIntelIndicatorValue())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val threatIntelIndicatorCategory
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatIntelIndicatorCategory())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val threatIntelIndicatorLastObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatIntelIndicatorLastObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val threatIntelIndicatorSource
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatIntelIndicatorSource())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val threatIntelIndicatorSourceUrl
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatIntelIndicatorSourceUrl())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourcePartition
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePartition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceRegion
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRegion())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceTags
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceImageId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceImageId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceIpV4Addresses
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceIpV4Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.IpFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceIpV6Addresses
        : Optional[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceIpV6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.IpFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceKeyName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceKeyName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceIamInstanceProfileArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.resourceAwsEc2InstanceIamInstanceProfileArn()
        )
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceVpcId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceVpcId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceSubnetId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceSubnetId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsEc2InstanceLaunchedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsEc2InstanceLaunchedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val resourceAwsS3BucketOwnerId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsS3BucketOwnerId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsS3BucketOwnerName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsS3BucketOwnerName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsIamAccessKeyUserName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsIamAccessKeyUserName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsIamAccessKeyPrincipalName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsIamAccessKeyPrincipalName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsIamAccessKeyStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsIamAccessKeyStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceAwsIamAccessKeyCreatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsIamAccessKeyCreatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val resourceAwsIamUserUserName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAwsIamUserUserName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceContainerName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceContainerName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceContainerImageId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceContainerImageId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceContainerImageName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceContainerImageName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceContainerLaunchedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceContainerLaunchedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val resourceDetailsOther
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDetailsOther())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
    override val complianceStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val verificationState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationState())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val workflowState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowState())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val workflowStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val recordState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordState())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val relatedFindingsProductArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindingsProductArn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val relatedFindingsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindingsId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val noteText
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noteText())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val noteUpdatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noteUpdatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val noteUpdatedBy
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noteUpdatedBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val keyword
        : Optional[List[zio.aws.securityhub.model.KeywordFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyword())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.KeywordFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsConfidence
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFieldsConfidence())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsCriticality
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFieldsCriticality())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsRelatedFindingsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFieldsRelatedFindingsId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsRelatedFindingsProductArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.findingProviderFieldsRelatedFindingsProductArn()
        )
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsSeverityLabel
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFieldsSeverityLabel())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsSeverityOriginal
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFieldsSeverityOriginal())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingProviderFieldsTypes
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingProviderFieldsTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val sample
        : Optional[List[zio.aws.securityhub.model.BooleanFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sample())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.BooleanFilter.wrap(item)
          }.toList
        )
    override val complianceSecurityControlId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSecurityControlId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val complianceAssociatedStandardsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceAssociatedStandardsId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
  ): zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly = new Wrapper(
    impl
  )
}
