package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketServerSideEncryptionConfiguration(
    rules: Optional[
      Iterable[zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration = {
    import AwsS3BucketServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
      .wrap(buildAwsValue())
}
object AwsS3BucketServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration =
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule.ReadOnly
    ]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
  ) extends zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly {
    override val rules: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
  ): zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
