package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails(
    days: Optional[Integer] = Optional.Absent,
    mode: Optional[NonEmptyString] = Optional.Absent,
    years: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails = {
    import AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
      .builder()
      .optionallyWith(days.map(value => value: java.lang.Integer))(_.days)
      .optionallyWith(
        mode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.mode)
      .optionallyWith(years.map(value => value: java.lang.Integer))(_.years)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails =
      zio.aws.securityhub.model
        .AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails(
          days.map(value => value),
          mode.map(value => value),
          years.map(value => value)
        )
    def days: Optional[Integer]
    def mode: Optional[NonEmptyString]
    def years: Optional[Integer]
    def getDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("days", days)
    def getMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("mode", mode)
    def getYears: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("years", years)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.ReadOnly {
    override val days: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.days())
      .map(value => value: Integer)
    override val mode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.mode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val years: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.years())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
  ): zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.ReadOnly =
    new Wrapper(impl)
}
