package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketObjectLockConfiguration(
    objectLockEnabled: Optional[NonEmptyString] = Optional.Absent,
    rule: Optional[
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfiguration = {
    import AwsS3BucketObjectLockConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfiguration
      .builder()
      .optionallyWith(
        objectLockEnabled.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.objectLockEnabled)
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketObjectLockConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketObjectLockConfiguration
      .wrap(buildAwsValue())
}
object AwsS3BucketObjectLockConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketObjectLockConfiguration =
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfiguration(
        objectLockEnabled.map(value => value),
        rule.map(value => value.asEditable)
      )
    def objectLockEnabled: Optional[NonEmptyString]
    def rule: Optional[
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails.ReadOnly
    ]
    def getObjectLockEnabled: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectLockEnabled", objectLockEnabled)
    def getRule: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfiguration
  ) extends zio.aws.securityhub.model.AwsS3BucketObjectLockConfiguration.ReadOnly {
    override val objectLockEnabled: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockEnabled())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val rule: Optional[
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rule())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfiguration
  ): zio.aws.securityhub.model.AwsS3BucketObjectLockConfiguration.ReadOnly =
    new Wrapper(impl)
}
