package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbPendingModifiedValues(
    dbInstanceClass: Optional[NonEmptyString] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    masterUserPassword: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    backupRetentionPeriod: Optional[Integer] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    licenseModel: Optional[NonEmptyString] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    dbInstanceIdentifier: Optional[NonEmptyString] = Optional.Absent,
    storageType: Optional[NonEmptyString] = Optional.Absent,
    caCertificateIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbSubnetGroupName: Optional[NonEmptyString] = Optional.Absent,
    pendingCloudWatchLogsExports: Optional[
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports
    ] = Optional.Absent,
    processorFeatures: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues = {
    import AwsRdsDbPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
      .builder()
      .optionallyWith(
        dbInstanceClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceClass)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        masterUserPassword.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        caCertificateIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.caCertificateIdentifier)
      .optionallyWith(
        dbSubnetGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroupName)
      .optionallyWith(
        pendingCloudWatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudWatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues
      .wrap(buildAwsValue())
}
object AwsRdsDbPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues =
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues(
        dbInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        masterUserPassword.map(value => value),
        port.map(value => value),
        backupRetentionPeriod.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        dbInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        caCertificateIdentifier.map(value => value),
        dbSubnetGroupName.map(value => value),
        pendingCloudWatchLogsExports.map(value => value.asEditable),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbInstanceClass: Optional[NonEmptyString]
    def allocatedStorage: Optional[Integer]
    def masterUserPassword: Optional[NonEmptyString]
    def port: Optional[Integer]
    def backupRetentionPeriod: Optional[Integer]
    def multiAZ: Optional[Boolean]
    def engineVersion: Optional[NonEmptyString]
    def licenseModel: Optional[NonEmptyString]
    def iops: Optional[Integer]
    def dbInstanceIdentifier: Optional[NonEmptyString]
    def storageType: Optional[NonEmptyString]
    def caCertificateIdentifier: Optional[NonEmptyString]
    def dbSubnetGroupName: Optional[NonEmptyString]
    def pendingCloudWatchLogsExports: Optional[
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly
    ]
    def processorFeatures: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ]
    def getDbInstanceClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMasterUserPassword: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "caCertificateIdentifier",
        caCertificateIdentifier
      )
    def getDbSubnetGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPendingCloudWatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudWatchLogsExports",
      pendingCloudWatchLogsExports
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
  ) extends zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly {
    override val dbInstanceClass: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceClass())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val masterUserPassword: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserPassword())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val backupRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: Integer)
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseModel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val dbInstanceIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val storageType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val caCertificateIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbSubnetGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val pendingCloudWatchLogsExports: Optional[
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingCloudWatchLogsExports())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.wrap(value)
      )
    override val processorFeatures: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.processorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
  ): zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
