package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbParameterGroup(
    dbParameterGroupName: Optional[NonEmptyString] = Optional.Absent,
    parameterApplyStatus: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup = {
    import AwsRdsDbParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup
      .builder()
      .optionallyWith(
        dbParameterGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbParameterGroupName)
      .optionallyWith(
        parameterApplyStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbParameterGroup.wrap(buildAwsValue())
}
object AwsRdsDbParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbParameterGroup =
      zio.aws.securityhub.model.AwsRdsDbParameterGroup(
        dbParameterGroupName.map(value => value),
        parameterApplyStatus.map(value => value)
      )
    def dbParameterGroupName: Optional[NonEmptyString]
    def parameterApplyStatus: Optional[NonEmptyString]
    def getDbParameterGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getParameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup
  ) extends zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly {
    override val dbParameterGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val parameterApplyStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterApplyStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup
  ): zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly = new Wrapper(
    impl
  )
}
