package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbInstanceDetails(
    associatedRoles: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole]
    ] = Optional.Absent,
    caCertificateIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbClusterIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbInstanceIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbInstanceClass: Optional[NonEmptyString] = Optional.Absent,
    dbInstancePort: Optional[Integer] = Optional.Absent,
    dbiResourceId: Optional[NonEmptyString] = Optional.Absent,
    dbName: Optional[NonEmptyString] = Optional.Absent,
    deletionProtection: Optional[Boolean] = Optional.Absent,
    endpoint: Optional[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint] =
      Optional.Absent,
    engine: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    instanceCreateTime: Optional[NonEmptyString] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    tdeCredentialArn: Optional[NonEmptyString] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup]
    ] = Optional.Absent,
    multiAz: Optional[Boolean] = Optional.Absent,
    enhancedMonitoringResourceArn: Optional[NonEmptyString] = Optional.Absent,
    dbInstanceStatus: Optional[NonEmptyString] = Optional.Absent,
    masterUsername: Optional[NonEmptyString] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    preferredBackupWindow: Optional[NonEmptyString] = Optional.Absent,
    backupRetentionPeriod: Optional[Integer] = Optional.Absent,
    dbSecurityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    dbParameterGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbParameterGroup]
    ] = Optional.Absent,
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    dbSubnetGroup: Optional[zio.aws.securityhub.model.AwsRdsDbSubnetGroup] =
      Optional.Absent,
    preferredMaintenanceWindow: Optional[NonEmptyString] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues
    ] = Optional.Absent,
    latestRestorableTime: Optional[NonEmptyString] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    readReplicaSourceDBInstanceIdentifier: Optional[NonEmptyString] =
      Optional.Absent,
    readReplicaDBInstanceIdentifiers: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    readReplicaDBClusterIdentifiers: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    licenseModel: Optional[NonEmptyString] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    optionGroupMemberships: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership]
    ] = Optional.Absent,
    characterSetName: Optional[NonEmptyString] = Optional.Absent,
    secondaryAvailabilityZone: Optional[NonEmptyString] = Optional.Absent,
    statusInfos: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbStatusInfo]
    ] = Optional.Absent,
    storageType: Optional[NonEmptyString] = Optional.Absent,
    domainMemberships: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbDomainMembership]
    ] = Optional.Absent,
    copyTagsToSnapshot: Optional[Boolean] = Optional.Absent,
    monitoringInterval: Optional[Integer] = Optional.Absent,
    monitoringRoleArn: Optional[NonEmptyString] = Optional.Absent,
    promotionTier: Optional[Integer] = Optional.Absent,
    timezone: Optional[NonEmptyString] = Optional.Absent,
    performanceInsightsEnabled: Optional[Boolean] = Optional.Absent,
    performanceInsightsKmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[Integer] = Optional.Absent,
    enabledCloudWatchLogsExports: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    processorFeatures: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
    ] = Optional.Absent,
    listenerEndpoint: Optional[
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint
    ] = Optional.Absent,
    maxAllocatedStorage: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails = {
    import AwsRdsDbInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
      .builder()
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        caCertificateIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.caCertificateIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        dbInstanceClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceClass)
      .optionallyWith(dbInstancePort.map(value => value: java.lang.Integer))(
        _.dbInstancePort
      )
      .optionallyWith(
        dbiResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbiResourceId)
      .optionallyWith(
        dbName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dbName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        instanceCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceCreateTime)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        tdeCredentialArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tdeCredentialArn)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(multiAz.map(value => value: java.lang.Boolean))(_.multiAz)
      .optionallyWith(
        enhancedMonitoringResourceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.enhancedMonitoringResourceArn)
      .optionallyWith(
        dbInstanceStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceStatus)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        preferredBackupWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        dbParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbParameterGroups)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.latestRestorableTime)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        readReplicaSourceDBInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.readReplicaSourceDBInstanceIdentifier)
      .optionallyWith(
        readReplicaDBInstanceIdentifiers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBInstanceIdentifiers)
      .optionallyWith(
        readReplicaDBClusterIdentifiers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBClusterIdentifiers)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupMemberships)
      .optionallyWith(
        characterSetName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.characterSetName)
      .optionallyWith(
        secondaryAvailabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value => value: java.lang.Integer)
      )(_.monitoringInterval)
      .optionallyWith(
        monitoringRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.monitoringRoleArn)
      .optionallyWith(promotionTier.map(value => value: java.lang.Integer))(
        _.promotionTier
      )
      .optionallyWith(
        timezone.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        performanceInsightsEnabled.map(value => value: java.lang.Boolean)
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKmsKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.performanceInsightsKmsKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          value: java.lang.Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enabledCloudWatchLogsExports.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudWatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(listenerEndpoint.map(value => value.buildAwsValue()))(
        _.listenerEndpoint
      )
      .optionallyWith(
        maxAllocatedStorage.map(value => value: java.lang.Integer)
      )(_.maxAllocatedStorage)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbInstanceDetails.wrap(buildAwsValue())
}
object AwsRdsDbInstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbInstanceDetails =
      zio.aws.securityhub.model.AwsRdsDbInstanceDetails(
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        caCertificateIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbInstanceIdentifier.map(value => value),
        dbInstanceClass.map(value => value),
        dbInstancePort.map(value => value),
        dbiResourceId.map(value => value),
        dbName.map(value => value),
        deletionProtection.map(value => value),
        endpoint.map(value => value.asEditable),
        engine.map(value => value),
        engineVersion.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        instanceCreateTime.map(value => value),
        kmsKeyId.map(value => value),
        publiclyAccessible.map(value => value),
        storageEncrypted.map(value => value),
        tdeCredentialArn.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiAz.map(value => value),
        enhancedMonitoringResourceArn.map(value => value),
        dbInstanceStatus.map(value => value),
        masterUsername.map(value => value),
        allocatedStorage.map(value => value),
        preferredBackupWindow.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbSecurityGroups.map(value => value),
        dbParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        dbSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        latestRestorableTime.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        readReplicaSourceDBInstanceIdentifier.map(value => value),
        readReplicaDBInstanceIdentifiers.map(value => value),
        readReplicaDBClusterIdentifiers.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        characterSetName.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        statusInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageType.map(value => value),
        domainMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        promotionTier.map(value => value),
        timezone.map(value => value),
        performanceInsightsEnabled.map(value => value),
        performanceInsightsKmsKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        enabledCloudWatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        listenerEndpoint.map(value => value.asEditable),
        maxAllocatedStorage.map(value => value)
      )
    def associatedRoles: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly]
    ]
    def caCertificateIdentifier: Optional[NonEmptyString]
    def dbClusterIdentifier: Optional[NonEmptyString]
    def dbInstanceIdentifier: Optional[NonEmptyString]
    def dbInstanceClass: Optional[NonEmptyString]
    def dbInstancePort: Optional[Integer]
    def dbiResourceId: Optional[NonEmptyString]
    def dbName: Optional[NonEmptyString]
    def deletionProtection: Optional[Boolean]
    def endpoint
        : Optional[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly]
    def engine: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def instanceCreateTime: Optional[NonEmptyString]
    def kmsKeyId: Optional[NonEmptyString]
    def publiclyAccessible: Optional[Boolean]
    def storageEncrypted: Optional[Boolean]
    def tdeCredentialArn: Optional[NonEmptyString]
    def vpcSecurityGroups: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ]
    def multiAz: Optional[Boolean]
    def enhancedMonitoringResourceArn: Optional[NonEmptyString]
    def dbInstanceStatus: Optional[NonEmptyString]
    def masterUsername: Optional[NonEmptyString]
    def allocatedStorage: Optional[Integer]
    def preferredBackupWindow: Optional[NonEmptyString]
    def backupRetentionPeriod: Optional[Integer]
    def dbSecurityGroups: Optional[List[NonEmptyString]]
    def dbParameterGroups: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly]
    ]
    def availabilityZone: Optional[NonEmptyString]
    def dbSubnetGroup
        : Optional[zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: Optional[NonEmptyString]
    def pendingModifiedValues: Optional[
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly
    ]
    def latestRestorableTime: Optional[NonEmptyString]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def readReplicaSourceDBInstanceIdentifier: Optional[NonEmptyString]
    def readReplicaDBInstanceIdentifiers: Optional[List[NonEmptyString]]
    def readReplicaDBClusterIdentifiers: Optional[List[NonEmptyString]]
    def licenseModel: Optional[NonEmptyString]
    def iops: Optional[Integer]
    def optionGroupMemberships: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly]
    ]
    def characterSetName: Optional[NonEmptyString]
    def secondaryAvailabilityZone: Optional[NonEmptyString]
    def statusInfos
        : Optional[List[zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly]]
    def storageType: Optional[NonEmptyString]
    def domainMemberships: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ]
    def copyTagsToSnapshot: Optional[Boolean]
    def monitoringInterval: Optional[Integer]
    def monitoringRoleArn: Optional[NonEmptyString]
    def promotionTier: Optional[Integer]
    def timezone: Optional[NonEmptyString]
    def performanceInsightsEnabled: Optional[Boolean]
    def performanceInsightsKmsKeyId: Optional[NonEmptyString]
    def performanceInsightsRetentionPeriod: Optional[Integer]
    def enabledCloudWatchLogsExports: Optional[List[NonEmptyString]]
    def processorFeatures: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ]
    def listenerEndpoint
        : Optional[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly]
    def maxAllocatedStorage: Optional[Integer]
    def getAssociatedRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "caCertificateIdentifier",
        caCertificateIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDbInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstancePort", dbInstancePort)
    def getDbiResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getDbName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getInstanceCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getTdeCredentialArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getMultiAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAz", multiAz)
    def getEnhancedMonitoringResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "enhancedMonitoringResourceArn",
        enhancedMonitoringResourceArn
      )
    def getDbInstanceStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getPreferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getDbParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getReadReplicaSourceDBInstanceIdentifier
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "readReplicaSourceDBInstanceIdentifier",
      readReplicaSourceDBInstanceIdentifier
    )
    def getReadReplicaDBInstanceIdentifiers
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "readReplicaDBInstanceIdentifiers",
      readReplicaDBInstanceIdentifiers
    )
    def getReadReplicaDBClusterIdentifiers
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "readReplicaDBClusterIdentifiers",
      readReplicaDBClusterIdentifiers
    )
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupMemberships",
      optionGroupMemberships
    )
    def getCharacterSetName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "secondaryAvailabilityZone",
        secondaryAvailabilityZone
      )
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPromotionTier: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getTimezone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "performanceInsightsKmsKeyId",
        performanceInsightsKmsKeyId
      )
    def getPerformanceInsightsRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "performanceInsightsRetentionPeriod",
        performanceInsightsRetentionPeriod
      )
    def getEnabledCloudWatchLogsExports
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "enabledCloudWatchLogsExports",
      enabledCloudWatchLogsExports
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getListenerEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("listenerEndpoint", listenerEndpoint)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly {
    override val associatedRoles: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.wrap(item)
        }.toList
      )
    override val caCertificateIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbClusterIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbInstanceIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbInstanceClass: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceClass())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbInstancePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstancePort())
      .map(value => value: Integer)
    override val dbiResourceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deletionProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtection())
      .map(value => value: Boolean)
    override val endpoint: Optional[
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.wrap(value)
      )
    override val engine: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val instanceCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val tdeCredentialArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tdeCredentialArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.wrap(item)
        }.toList
      )
    override val multiAz: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAz())
      .map(value => value: Boolean)
    override val enhancedMonitoringResourceArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedMonitoringResourceArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbInstanceStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val masterUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUsername())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val preferredBackupWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val backupRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: Integer)
    override val dbSecurityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val dbParameterGroups: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbParameterGroup.wrap(item)
        }.toList
      )
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbSubnetGroup
        : Optional[zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.securityhub.model.AwsRdsDbSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val pendingModifiedValues: Optional[
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.wrap(value)
      )
    override val latestRestorableTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestRestorableTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val readReplicaSourceDBInstanceIdentifier
        : Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.readReplicaSourceDBInstanceIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val readReplicaDBInstanceIdentifiers
        : Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.readReplicaDBInstanceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val readReplicaDBClusterIdentifiers
        : Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.readReplicaDBClusterIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val licenseModel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val optionGroupMemberships: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.wrap(item)
        }.toList
      )
    override val characterSetName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.characterSetName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val secondaryAvailabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryAvailabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val statusInfos: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbStatusInfo.wrap(item)
        }.toList
      )
    override val storageType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainMemberships: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbDomainMembership.wrap(item)
        }.toList
      )
    override val copyTagsToSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToSnapshot())
      .map(value => value: Boolean)
    override val monitoringInterval: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringInterval())
      .map(value => value: Integer)
    override val monitoringRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val promotionTier: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.promotionTier())
      .map(value => value: Integer)
    override val timezone: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val performanceInsightsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsEnabled())
        .map(value => value: Boolean)
    override val performanceInsightsKmsKeyId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKmsKeyId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val performanceInsightsRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: Integer)
    override val enabledCloudWatchLogsExports: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudWatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val processorFeatures: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.processorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(item)
        }.toList
      )
    override val listenerEndpoint: Optional[
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerEndpoint())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.wrap(value)
      )
    override val maxAllocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAllocatedStorage())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
  ): zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly = new Wrapper(
    impl
  )
}
