package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterSnapshotDetails(
    availabilityZones: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    snapshotCreateTime: Optional[NonEmptyString] = Optional.Absent,
    engine: Optional[NonEmptyString] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    clusterCreateTime: Optional[NonEmptyString] = Optional.Absent,
    masterUsername: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    licenseModel: Optional[NonEmptyString] = Optional.Absent,
    snapshotType: Optional[NonEmptyString] = Optional.Absent,
    percentProgress: Optional[Integer] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    dbClusterIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbClusterSnapshotIdentifier: Optional[NonEmptyString] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails = {
    import AwsRdsDbClusterSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        snapshotCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotCreateTime)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        clusterCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterCreateTime)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(
        snapshotType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotType)
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dbClusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails
      .wrap(buildAwsValue())
}
object AwsRdsDbClusterSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails =
      zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails(
        availabilityZones.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        vpcId.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        snapshotType.map(value => value),
        percentProgress.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value)
      )
    def availabilityZones: Optional[List[NonEmptyString]]
    def snapshotCreateTime: Optional[NonEmptyString]
    def engine: Optional[NonEmptyString]
    def allocatedStorage: Optional[Integer]
    def status: Optional[NonEmptyString]
    def port: Optional[Integer]
    def vpcId: Optional[NonEmptyString]
    def clusterCreateTime: Optional[NonEmptyString]
    def masterUsername: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def licenseModel: Optional[NonEmptyString]
    def snapshotType: Optional[NonEmptyString]
    def percentProgress: Optional[Integer]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[NonEmptyString]
    def dbClusterIdentifier: Optional[NonEmptyString]
    def dbClusterSnapshotIdentifier: Optional[NonEmptyString]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSnapshotCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getClusterCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly {
    override val availabilityZones: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val snapshotCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val engine: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val masterUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUsername())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseModel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snapshotType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val percentProgress: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: Integer)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbClusterSnapshotIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshotIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
  ): zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly =
    new Wrapper(impl)
}
