package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallFirewallPolicyDetails(
    firewallPolicy: Optional[zio.aws.securityhub.model.FirewallPolicyDetails] =
      Optional.Absent,
    firewallPolicyArn: Optional[NonEmptyString] = Optional.Absent,
    firewallPolicyId: Optional[NonEmptyString] = Optional.Absent,
    firewallPolicyName: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails = {
    import AwsNetworkFirewallFirewallPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
      .builder()
      .optionallyWith(firewallPolicy.map(value => value.buildAwsValue()))(
        _.firewallPolicy
      )
      .optionallyWith(
        firewallPolicyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        firewallPolicyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyId)
      .optionallyWith(
        firewallPolicyName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallFirewallPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails(
        firewallPolicy.map(value => value.asEditable),
        firewallPolicyArn.map(value => value),
        firewallPolicyId.map(value => value),
        firewallPolicyName.map(value => value),
        description.map(value => value)
      )
    def firewallPolicy
        : Optional[zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly]
    def firewallPolicyArn: Optional[NonEmptyString]
    def firewallPolicyId: Optional[NonEmptyString]
    def firewallPolicyName: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def getFirewallPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("firewallPolicy", firewallPolicy)
    def getFirewallPolicyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getFirewallPolicyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyId", firewallPolicyId)
    def getFirewallPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyName", firewallPolicyName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly {
    override val firewallPolicy
        : Optional[zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicy())
        .map(value =>
          zio.aws.securityhub.model.FirewallPolicyDetails.wrap(value)
        )
    override val firewallPolicyArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val firewallPolicyId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val firewallPolicyName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly =
    new Wrapper(impl)
}
