package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMountPoint(
    sourceVolume: Optional[NonEmptyString] = Optional.Absent,
    containerPath: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMountPoint = {
    import AwsMountPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMountPoint
      .builder()
      .optionallyWith(
        sourceVolume.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVolume)
      .optionallyWith(
        containerPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerPath)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsMountPoint.ReadOnly =
    zio.aws.securityhub.model.AwsMountPoint.wrap(buildAwsValue())
}
object AwsMountPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMountPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsMountPoint =
      zio.aws.securityhub.model.AwsMountPoint(
        sourceVolume.map(value => value),
        containerPath.map(value => value)
      )
    def sourceVolume: Optional[NonEmptyString]
    def containerPath: Optional[NonEmptyString]
    def getSourceVolume: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVolume", sourceVolume)
    def getContainerPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerPath", containerPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMountPoint
  ) extends zio.aws.securityhub.model.AwsMountPoint.ReadOnly {
    override val sourceVolume: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVolume())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val containerPath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMountPoint
  ): zio.aws.securityhub.model.AwsMountPoint.ReadOnly = new Wrapper(impl)
}
