package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionDetails(
    code: Optional[zio.aws.securityhub.model.AwsLambdaFunctionCode] =
      Optional.Absent,
    codeSha256: Optional[NonEmptyString] = Optional.Absent,
    deadLetterConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig
    ] = Optional.Absent,
    environment: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment
    ] = Optional.Absent,
    functionName: Optional[NonEmptyString] = Optional.Absent,
    handler: Optional[NonEmptyString] = Optional.Absent,
    kmsKeyArn: Optional[NonEmptyString] = Optional.Absent,
    lastModified: Optional[NonEmptyString] = Optional.Absent,
    layers: Optional[
      Iterable[zio.aws.securityhub.model.AwsLambdaFunctionLayer]
    ] = Optional.Absent,
    masterArn: Optional[NonEmptyString] = Optional.Absent,
    memorySize: Optional[Integer] = Optional.Absent,
    revisionId: Optional[NonEmptyString] = Optional.Absent,
    role: Optional[NonEmptyString] = Optional.Absent,
    runtime: Optional[NonEmptyString] = Optional.Absent,
    timeout: Optional[Integer] = Optional.Absent,
    tracingConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig
    ] = Optional.Absent,
    vpcConfig: Optional[zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig] =
      Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    architectures: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    packageType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails = {
    import AwsLambdaFunctionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
      .builder()
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        codeSha256.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.codeSha256)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        functionName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.functionName)
      .optionallyWith(
        handler.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.handler)
      .optionallyWith(
        kmsKeyArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        lastModified.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastModified)
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(
        masterArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.masterArn)
      .optionallyWith(memorySize.map(value => value: java.lang.Integer))(
        _.memorySize
      )
      .optionallyWith(
        revisionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        role.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        runtime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.runtime)
      .optionallyWith(timeout.map(value => value: java.lang.Integer))(_.timeout)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.architectures)
      .optionallyWith(
        packageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.packageType)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionDetails.wrap(buildAwsValue())
}
object AwsLambdaFunctionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionDetails =
      zio.aws.securityhub.model.AwsLambdaFunctionDetails(
        code.map(value => value.asEditable),
        codeSha256.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        functionName.map(value => value),
        handler.map(value => value),
        kmsKeyArn.map(value => value),
        lastModified.map(value => value),
        layers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        masterArn.map(value => value),
        memorySize.map(value => value),
        revisionId.map(value => value),
        role.map(value => value),
        runtime.map(value => value),
        timeout.map(value => value),
        tracingConfig.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        version.map(value => value),
        architectures.map(value => value),
        packageType.map(value => value)
      )
    def code: Optional[zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly]
    def codeSha256: Optional[NonEmptyString]
    def deadLetterConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly
    ]
    def environment: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly
    ]
    def functionName: Optional[NonEmptyString]
    def handler: Optional[NonEmptyString]
    def kmsKeyArn: Optional[NonEmptyString]
    def lastModified: Optional[NonEmptyString]
    def layers: Optional[
      List[zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly]
    ]
    def masterArn: Optional[NonEmptyString]
    def memorySize: Optional[Integer]
    def revisionId: Optional[NonEmptyString]
    def role: Optional[NonEmptyString]
    def runtime: Optional[NonEmptyString]
    def timeout: Optional[Integer]
    def tracingConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly
    ]
    def vpcConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly
    ]
    def version: Optional[NonEmptyString]
    def architectures: Optional[List[NonEmptyString]]
    def packageType: Optional[NonEmptyString]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getCodeSha256: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("codeSha256", codeSha256)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getFunctionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getHandler: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("handler", handler)
    def getKmsKeyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getLastModified: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLayers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly
    ]] = AwsError.unwrapOptionField("layers", layers)
    def getMasterArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterArn", masterArn)
    def getMemorySize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getRevisionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("role", role)
    def getRuntime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTracingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getArchitectures: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("architectures", architectures)
    def getPackageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packageType", packageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly {
    override val code
        : Optional[zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.securityhub.model.AwsLambdaFunctionCode.wrap(value)
        )
    override val codeSha256: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSha256())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deadLetterConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deadLetterConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.wrap(value)
      )
    override val environment: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environment())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.wrap(value)
      )
    override val functionName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.functionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val handler: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.handler())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastModified: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val layers: Optional[
      List[zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsLambdaFunctionLayer.wrap(item)
        }.toList
      )
    override val masterArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.masterArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val memorySize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.memorySize())
      .map(value => value: Integer)
    override val revisionId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val role: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val runtime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.runtime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => value: Integer)
    override val tracingConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tracingConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.wrap(value)
      )
    override val vpcConfig: Optional[
      zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.wrap(value)
      )
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val architectures: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val packageType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.packageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
  ): zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly = new Wrapper(
    impl
  )
}
