package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsKinesisStreamDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    streamEncryption: Optional[
      zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
    ] = Optional.Absent,
    shardCount: Optional[Integer] = Optional.Absent,
    retentionPeriodHours: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamDetails = {
    import AwsKinesisStreamDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(streamEncryption.map(value => value.buildAwsValue()))(
        _.streamEncryption
      )
      .optionallyWith(shardCount.map(value => value: java.lang.Integer))(
        _.shardCount
      )
      .optionallyWith(
        retentionPeriodHours.map(value => value: java.lang.Integer)
      )(_.retentionPeriodHours)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsKinesisStreamDetails.ReadOnly =
    zio.aws.securityhub.model.AwsKinesisStreamDetails.wrap(buildAwsValue())
}
object AwsKinesisStreamDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsKinesisStreamDetails =
      zio.aws.securityhub.model.AwsKinesisStreamDetails(
        name.map(value => value),
        arn.map(value => value),
        streamEncryption.map(value => value.asEditable),
        shardCount.map(value => value),
        retentionPeriodHours.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def streamEncryption: Optional[
      zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.ReadOnly
    ]
    def shardCount: Optional[Integer]
    def retentionPeriodHours: Optional[Integer]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getStreamEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("streamEncryption", streamEncryption)
    def getShardCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("shardCount", shardCount)
    def getRetentionPeriodHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("retentionPeriodHours", retentionPeriodHours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamDetails
  ) extends zio.aws.securityhub.model.AwsKinesisStreamDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val streamEncryption: Optional[
      zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamEncryption())
      .map(value =>
        zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
          .wrap(value)
      )
    override val shardCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.shardCount())
      .map(value => value: Integer)
    override val retentionPeriodHours: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPeriodHours())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamDetails
  ): zio.aws.securityhub.model.AwsKinesisStreamDetails.ReadOnly = new Wrapper(
    impl
  )
}
