package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamAccessKeySessionContextSessionIssuer(
    `type`: Optional[NonEmptyString] = Optional.Absent,
    principalId: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    accountId: Optional[NonEmptyString] = Optional.Absent,
    userName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer = {
    import AwsIamAccessKeySessionContextSessionIssuer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        principalId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        userName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly =
    zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
      .wrap(buildAwsValue())
}
object AwsIamAccessKeySessionContextSessionIssuer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer =
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer(
        `type`.map(value => value),
        principalId.map(value => value),
        arn.map(value => value),
        accountId.map(value => value),
        userName.map(value => value)
      )
    def `type`: Optional[NonEmptyString]
    def principalId: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def accountId: Optional[NonEmptyString]
    def userName: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getPrincipalId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
  ) extends zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
  ): zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly =
    new Wrapper(impl)
}
