package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGuardDutyDetectorDataSourcesDetails(
    cloudTrail: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
    ] = Optional.Absent,
    dnsLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
    ] = Optional.Absent,
    flowLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesFlowLogsDetails
    ] = Optional.Absent,
    kubernetes: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
    ] = Optional.Absent,
    malwareProtection: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
    ] = Optional.Absent,
    s3Logs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesS3LogsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails = {
    import AwsGuardDutyDetectorDataSourcesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
      .builder()
      .optionallyWith(cloudTrail.map(value => value.buildAwsValue()))(
        _.cloudTrail
      )
      .optionallyWith(dnsLogs.map(value => value.buildAwsValue()))(_.dnsLogs)
      .optionallyWith(flowLogs.map(value => value.buildAwsValue()))(_.flowLogs)
      .optionallyWith(kubernetes.map(value => value.buildAwsValue()))(
        _.kubernetes
      )
      .optionallyWith(malwareProtection.map(value => value.buildAwsValue()))(
        _.malwareProtection
      )
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
      .wrap(buildAwsValue())
}
object AwsGuardDutyDetectorDataSourcesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails =
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails(
        cloudTrail.map(value => value.asEditable),
        dnsLogs.map(value => value.asEditable),
        flowLogs.map(value => value.asEditable),
        kubernetes.map(value => value.asEditable),
        malwareProtection.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable)
      )
    def cloudTrail: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails.ReadOnly
    ]
    def dnsLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails.ReadOnly
    ]
    def flowLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesFlowLogsDetails.ReadOnly
    ]
    def kubernetes: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails.ReadOnly
    ]
    def malwareProtection: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.ReadOnly
    ]
    def s3Logs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesS3LogsDetails.ReadOnly
    ]
    def getCloudTrail: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails.ReadOnly
    ] = AwsError.unwrapOptionField("cloudTrail", cloudTrail)
    def getDnsLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("dnsLogs", dnsLogs)
    def getFlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesFlowLogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("flowLogs", flowLogs)
    def getKubernetes: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetes", kubernetes)
    def getMalwareProtection: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("malwareProtection", malwareProtection)
    def getS3Logs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesS3LogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
  ) extends zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails.ReadOnly {
    override val cloudTrail: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudTrail())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
          .wrap(value)
      )
    override val dnsLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
          .wrap(value)
      )
    override val flowLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesFlowLogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.flowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesFlowLogsDetails
          .wrap(value)
      )
    override val kubernetes: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kubernetes())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
          .wrap(value)
      )
    override val malwareProtection: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.malwareProtection())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
          .wrap(value)
      )
    override val s3Logs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesS3LogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Logs())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesS3LogsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
  ): zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails.ReadOnly =
    new Wrapper(impl)
}
