package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGuardDutyDetectorDataSourcesCloudTrailDetails(
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails = {
    import AwsGuardDutyDetectorDataSourcesCloudTrailDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
      .builder()
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails.ReadOnly =
    zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
      .wrap(buildAwsValue())
}
object AwsGuardDutyDetectorDataSourcesCloudTrailDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails =
      zio.aws.securityhub.model
        .AwsGuardDutyDetectorDataSourcesCloudTrailDetails(
          status.map(value => value)
        )
    def status: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
  ) extends zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails.ReadOnly {
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
  ): zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesCloudTrailDetails.ReadOnly =
    new Wrapper(impl)
}
